/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.alibaba.druid.sql.visitor.functions.Concat;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.alibaba.druid.sql.visitor.functions.Instr;
import com.alibaba.druid.sql.visitor.functions.Lcase;
import com.alibaba.druid.sql.visitor.functions.Length;
import com.alibaba.druid.sql.visitor.functions.Lpad;
import com.alibaba.druid.sql.visitor.functions.Ltrim;
import com.alibaba.druid.sql.visitor.functions.Reverse;
import com.alibaba.druid.sql.visitor.functions.Substring;
import com.alibaba.druid.sql.visitor.functions.ToChar;
import com.alibaba.druid.sql.visitor.functions.Trim;
import com.alibaba.druid.sql.visitor.functions.Ucase;
import com.oceanbase.partition.calculator.function.Abs;
import com.oceanbase.partition.calculator.function.Ceil;
import com.oceanbase.partition.calculator.function.Floor;
import com.oceanbase.partition.calculator.function.Mod;
import com.oceanbase.partition.calculator.function.Replace;
import com.oceanbase.partition.calculator.function.Rtrim;
import com.oceanbase.partition.calculator.function.mysql.Month;
import com.oceanbase.partition.calculator.function.mysql.TimeToSec;
import com.oceanbase.partition.calculator.function.mysql.ToDays;
import com.oceanbase.partition.calculator.function.mysql.UnixTimestamp;
import com.oceanbase.partition.calculator.function.mysql.Year;
import com.oceanbase.partition.calculator.function.oracle.ToDate;
import com.oceanbase.partition.calculator.function.oracle.ToTimestamp;
import org.apache.commons.lang3.StringUtils;

public enum SqlFunctions {
    ABS("abs", Abs.instance),
    YEAR("year", Year.instance),
    INSTR("instr", Instr.instance),
    LCASE("lower", Lcase.instance),
    LENGTH("length", Length.instance),
    LPAD("lpad", Lpad.instance),
    LTRIM("ltrim", Ltrim.instance),
    SUBSTR("substr", Substring.instance),
    SUBSTRING("substring", Substring.instance),
    TOCHAR("to_char", ToChar.instance),
    TODATE("to_date", ToDate.instance),
    TOTIMESTAMP("to_timestamp", ToTimestamp.instance),
    TRIM("trim", Trim.instance),
    RTRIM("rtrim", Rtrim.instance),
    UCASE("upper", Ucase.instance),
    REVERSE("reverse", Reverse.instance),
    CONCAT("concat", Concat.instance),
    TODAYS("to_days", ToDays.instance),
    REPLACE("replace", Replace.instance),
    TIMETOSEC("time_to_sec", TimeToSec.instance),
    MOD("mod", Mod.instance),
    CEIL("ceil", Ceil.instance),
    FLOOR("floor", Floor.instance),
    MONTH("month", Month.instance),
    UNIX_TIMESTAMP("unix_timestamp", UnixTimestamp.instance);

    private String name;
    private Function function;

    private SqlFunctions(String name, Function function) {
        this.name = name;
        this.function = function;
    }

    public static Function getByName(String methodName) {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new IllegalArgumentException("input method name is null");
        }
        for (SqlFunctions function : SqlFunctions.values()) {
            if (!function.getName().equalsIgnoreCase(methodName)) continue;
            return function.getFunction();
        }
        throw new UnsupportedOperationException("function is unsupported by the name: [" + methodName + "]");
    }

    public String getName() {
        return this.name;
    }

    public Function getFunction() {
        return this.function;
    }
}

