/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public final class ObCollationType
extends Enum<ObCollationType> {
    public static final /* enum */ ObCollationType CS_TYPE_INVALID;
    public static final /* enum */ ObCollationType CS_TYPE_GBK_CHINESE_CI;
    public static final /* enum */ ObCollationType CS_TYPE_UTF8MB4_GENERAL_CI;
    public static final /* enum */ ObCollationType CS_TYPE_UTF8MB4_BIN;
    public static final /* enum */ ObCollationType CS_TYPE_UTF16_GENERAL_CI;
    public static final /* enum */ ObCollationType CS_TYPE_UTF16_BIN;
    public static final /* enum */ ObCollationType CS_TYPE_BINARY;
    public static final /* enum */ ObCollationType CS_TYPE_GBK_BIN;
    public static final /* enum */ ObCollationType CS_TYPE_COLLATION_FREE;
    public static final /* enum */ ObCollationType CS_TYPE_UTF16_UNICODE_CI;
    public static final /* enum */ ObCollationType CS_TYPE_ANY;
    public static final /* enum */ ObCollationType CS_TYPE_UTF8MB4_UNICODE_CI;
    public static final /* enum */ ObCollationType CS_TYPE_GB18030_CHINESE_CI;
    public static final /* enum */ ObCollationType CS_TYPE_GB18030_BIN;
    public static final /* enum */ ObCollationType CS_TYPE_MAX;
    private static final Map<Long, ObCollationType> INDEX_MAPPING;
    private static final Map<String, ObCollationType> NAME_MAPPING;
    private String name = "";
    private long index = -1L;
    private static final /* synthetic */ ObCollationType[] $VALUES;

    public static ObCollationType[] values() {
        return (ObCollationType[])$VALUES.clone();
    }

    public static ObCollationType valueOf(String name) {
        return Enum.valueOf(ObCollationType.class, name);
    }

    private ObCollationType(String name, long index) {
        this.name = name;
        this.index = index;
    }

    public static ObCollationType getObCollationType(long index) {
        ObCollationType collationType = INDEX_MAPPING.getOrDefault(index, CS_TYPE_INVALID);
        return collationType == CS_TYPE_INVALID ? CS_TYPE_UTF8MB4_GENERAL_CI : collationType;
    }

    public static ObCollationType getObCollationType(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String upper = name.toUpperCase(Locale.getDefault());
        ObCollationType collationType = NAME_MAPPING.getOrDefault(upper, CS_TYPE_INVALID);
        return collationType == CS_TYPE_INVALID ? CS_TYPE_UTF8MB4_GENERAL_CI : collationType;
    }

    public String getName() {
        return this.name;
    }

    public long getIndex() {
        return this.index;
    }

    static {
        ObCollationType[] obCollationTypes;
        CS_TYPE_INVALID = new ObCollationType("CS_TYPE_INVALID", 0L);
        CS_TYPE_GBK_CHINESE_CI = new ObCollationType("CS_TYPE_GBK_CHINESE_CI", 28L);
        CS_TYPE_UTF8MB4_GENERAL_CI = new ObCollationType("CS_TYPE_UTF8MB4_GENERAL_CI", 45L);
        CS_TYPE_UTF8MB4_BIN = new ObCollationType("CS_TYPE_UTF8MB4_BIN", 46L);
        CS_TYPE_UTF16_GENERAL_CI = new ObCollationType("CS_TYPE_UTF16_GENERAL_CI", 54L);
        CS_TYPE_UTF16_BIN = new ObCollationType("CS_TYPE_UTF16_BIN", 55L);
        CS_TYPE_BINARY = new ObCollationType("CS_TYPE_BINARY", 63L);
        CS_TYPE_GBK_BIN = new ObCollationType("CS_TYPE_GBK_BIN", 87L);
        CS_TYPE_COLLATION_FREE = new ObCollationType("CS_TYPE_COLLATION_FREE", 100L);
        CS_TYPE_UTF16_UNICODE_CI = new ObCollationType("CS_TYPE_UTF16_UNICODE_CI", 101L);
        CS_TYPE_ANY = new ObCollationType("CS_TYPE_ANY", 125L);
        CS_TYPE_UTF8MB4_UNICODE_CI = new ObCollationType("CS_TYPE_UTF8MB4_UNICODE_CI", 224L);
        CS_TYPE_GB18030_CHINESE_CI = new ObCollationType("CS_TYPE_GB18030_CHINESE_CI", 248L);
        CS_TYPE_GB18030_BIN = new ObCollationType("CS_TYPE_GB18030_BIN", 249L);
        CS_TYPE_MAX = new ObCollationType("CS_TYPE_MAX", 250L);
        $VALUES = new ObCollationType[]{CS_TYPE_INVALID, CS_TYPE_GBK_CHINESE_CI, CS_TYPE_UTF8MB4_GENERAL_CI, CS_TYPE_UTF8MB4_BIN, CS_TYPE_UTF16_GENERAL_CI, CS_TYPE_UTF16_BIN, CS_TYPE_BINARY, CS_TYPE_GBK_BIN, CS_TYPE_COLLATION_FREE, CS_TYPE_UTF16_UNICODE_CI, CS_TYPE_ANY, CS_TYPE_UTF8MB4_UNICODE_CI, CS_TYPE_GB18030_CHINESE_CI, CS_TYPE_GB18030_BIN, CS_TYPE_MAX};
        INDEX_MAPPING = new HashMap<Long, ObCollationType>(6);
        NAME_MAPPING = new HashMap<String, ObCollationType>(6);
        for (ObCollationType obCollationType : obCollationTypes = ObCollationType.values()) {
            NAME_MAPPING.putIfAbsent(obCollationType.getName(), obCollationType);
            INDEX_MAPPING.putIfAbsent(obCollationType.getIndex(), obCollationType);
        }
    }
}

