/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.algo.hash;

import com.oceanbase.partition.calculator.constants.Constants;
import java.math.BigInteger;

public final class MurmurHash {
    private MurmurHash() {
    }

    public static int hash32(byte[] data, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length >> 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data[i4 + 0] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static int hash32(byte[] data, int length) {
        return MurmurHash.hash32(data, length, -1756908916);
    }

    public static int hash32(String text) {
        byte[] bytes = text.getBytes();
        return MurmurHash.hash32(bytes, bytes.length);
    }

    public static int hash32(String text, int from, int length) {
        return MurmurHash.hash32(text.substring(from, from + length));
    }

    public static BigInteger hash64(byte[] data, int length, BigInteger seed) {
        return MurmurHash.hash64ByBigInt(data, length, seed).mod(Constants.LONG_MOD_VALUE);
    }

    public static BigInteger hash64ByBigInt(byte[] data, int length, BigInteger seed) {
        BigInteger m = Constants.HASH_SEED_VALUE;
        int r = 47;
        BigInteger h = MurmurHash.xor(seed, MurmurHash.multiply(m, BigInteger.valueOf(length)));
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long longVal = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48);
            BigInteger k = BigInteger.valueOf(longVal).add(BigInteger.valueOf((long)data[i8 + 7] & 0xFFL).shiftLeft(56));
            k = MurmurHash.multiply(k, m);
            k = MurmurHash.xor(k, k.shiftRight(47));
            k = MurmurHash.multiply(k, m);
            h = MurmurHash.xor(h, k);
            h = MurmurHash.multiply(h, m);
        }
        switch (length % 8) {
            case 7: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48));
            }
            case 6: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40));
            }
            case 5: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32));
            }
            case 4: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24));
            }
            case 3: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16));
            }
            case 2: {
                h = MurmurHash.xor(h, BigInteger.valueOf((long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8));
            }
            case 1: {
                h = MurmurHash.xor(h, BigInteger.valueOf(data[length & 0xFFFFFFF8] & 0xFF));
                h = MurmurHash.multiply(h, m);
            }
        }
        h = MurmurHash.xor(h, h.shiftRight(47));
        h = MurmurHash.multiply(h, m);
        h = MurmurHash.xor(h, h.shiftRight(47));
        return h;
    }

    public static BigInteger hash64(byte[] data, int length) {
        return MurmurHash.hash64(data, length, Constants.BIGINTEGER_HASH_SEED);
    }

    public static BigInteger hash64(String text) {
        byte[] bytes = text.getBytes();
        return MurmurHash.hash64(bytes, bytes.length);
    }

    public static BigInteger hash64(String text, int from, int length) {
        return MurmurHash.hash64(text.substring(from, from + length));
    }

    private static BigInteger multiply(BigInteger left, BigInteger right) {
        BigInteger res = left.multiply(right);
        return res.compareTo(Constants.LONG_MOD_VALUE) > 0 ? res.mod(Constants.LONG_MOD_VALUE) : res;
    }

    private static BigInteger xor(BigInteger left, BigInteger right) {
        BigInteger res = left.xor(right);
        return res.compareTo(Constants.LONG_MOD_VALUE) > 0 ? res.mod(Constants.LONG_MOD_VALUE) : res;
    }
}

