/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class TableCache<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, T> cache;

    private Map<String, T> getCache() {
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap<String, T>();
        }
        return this.cache;
    }

    public Collection<T> getAll() {
        return this.getCache().values();
    }

    public T get(String tableId, Supplier<T> supplier) {
        if (this.getCache().containsKey(tableId)) {
            return this.getCache().get(tableId);
        }
        T t = supplier.get();
        this.getCache().put(tableId, t);
        return t;
    }

    public void remove(String tableId) {
        this.getCache().remove(tableId);
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

