/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.utils;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OptionUtils.class);

    private OptionUtils() {
    }

    public static void printOptions(String identifier, Map<String, String> config) {
        Map hideMap = ConfigurationUtils.hideSensitiveValues(config);
        LOG.info("Print {} connector configuration:", (Object)identifier);
        for (String key : hideMap.keySet()) {
            LOG.info("{} = {}", (Object)key, hideMap.get(key));
        }
    }

    public static Properties parseProperties(String propsStr) {
        if (StringUtils.isBlank((CharSequence)propsStr)) {
            return null;
        }
        Properties props = new Properties();
        for (String propStr : propsStr.split(";")) {
            if (StringUtils.isBlank((CharSequence)propStr)) continue;
            String[] pair = propStr.trim().split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("properties must have one key value pair");
            }
            props.put(pair[0].trim(), pair[1].trim());
        }
        return props;
    }
}

