/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.table;

import com.oceanbase.connector.flink.table.Table;
import com.oceanbase.connector.flink.table.TableId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.SerializableFunction;

public class TableInfo
implements Table {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final List<String> primaryKey;
    private final List<String> fieldNames;
    private final Map<String, Integer> fieldIndexMap;
    private final List<LogicalType> dataTypes;
    private final SerializableFunction<String, String> placeholderFunc;

    public TableInfo(TableId tableId, ResolvedSchema resolvedSchema) {
        this(tableId, resolvedSchema.getPrimaryKey().map(UniqueConstraint::getColumns).orElse(null), resolvedSchema.getColumnNames(), resolvedSchema.getColumnDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList()), null);
    }

    public TableInfo(@Nonnull TableId tableId, @Nullable List<String> primaryKey, @Nonnull List<String> fieldNames, @Nonnull List<LogicalType> dataTypes, @Nullable SerializableFunction<String, String> placeholderFunc) {
        this.tableId = tableId;
        this.primaryKey = primaryKey;
        this.fieldNames = fieldNames;
        this.dataTypes = dataTypes;
        this.fieldIndexMap = IntStream.range(0, fieldNames.size()).boxed().collect(Collectors.toMap(fieldNames::get, i -> i));
        this.placeholderFunc = placeholderFunc;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public List<String> getKey() {
        return this.primaryKey;
    }

    @Override
    public Integer getFieldIndex(String fieldName) {
        return this.fieldIndexMap.get(fieldName);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<LogicalType> getDataTypes() {
        return this.dataTypes;
    }

    public SerializableFunction<String, String> getPlaceholderFunc() {
        return this.placeholderFunc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo that = (TableInfo)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.primaryKey, that.primaryKey) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.fieldIndexMap, that.fieldIndexMap) && Objects.equals(this.dataTypes, that.dataTypes);
    }
}

