/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.table;

import java.io.Serializable;
import javax.annotation.Nonnull;

public class TableId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Identifier identifier;
    private final String schemaName;
    private final String tableName;

    public TableId(@Nonnull String schemaName, @Nonnull String tableName) {
        this((schema, table) -> String.format("\"%s\".\"%s\"", schema, table), schemaName, tableName);
    }

    public TableId(@Nonnull Identifier identifier, @Nonnull String schemaName, @Nonnull String tableName) {
        this.identifier = identifier;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String identifier() {
        return this.identifier.identifier(this.schemaName, this.tableName);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @FunctionalInterface
    public static interface Identifier
    extends Serializable {
        public String identifier(String var1, String var2);
    }
}

