/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.table;

import com.oceanbase.connector.flink.table.Table;
import com.oceanbase.connector.flink.table.TableId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class HTableInfo
implements Table {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final String rowKeyName;
    private final LogicalType rowKeyType;
    private final Map<String, Integer> fieldIndexMap;
    private final List<String> familyNames;
    private final Map<String, String[]> columnNameMap;
    private final Map<String, LogicalType[]> columnTypeMap;

    public HTableInfo(TableId tableId, ResolvedSchema resolvedSchema) {
        this(tableId, HTableInfo.rowKeyColumn(resolvedSchema).getName(), HTableInfo.rowKeyColumn(resolvedSchema).getDataType().getLogicalType(), HTableInfo.columns(resolvedSchema).stream().map(Column::getName).collect(Collectors.toList()), HTableInfo.familyColumns(resolvedSchema).stream().collect(Collectors.toMap(Column::getName, family -> ((RowType)family.getDataType().getLogicalType()).getFields().stream().map(RowType.RowField::getName).collect(Collectors.toList()).toArray(new String[0]))), HTableInfo.familyColumns(resolvedSchema).stream().collect(Collectors.toMap(Column::getName, family -> ((RowType)family.getDataType().getLogicalType()).getFields().stream().map(RowType.RowField::getType).collect(Collectors.toList()).toArray(new LogicalType[0]))));
    }

    private static List<Column> columns(ResolvedSchema resolvedSchema) {
        return resolvedSchema.getColumns();
    }

    private static Column rowKeyColumn(ResolvedSchema resolvedSchema) {
        List columns = HTableInfo.columns(resolvedSchema).stream().filter(column -> column.getDataType().getLogicalType().getTypeRoot() != LogicalTypeRoot.ROW).collect(Collectors.toList());
        if (columns.size() != 1) {
            throw new IllegalArgumentException("There should be exactly one field that is not ROW type.");
        }
        return (Column)columns.get(0);
    }

    private static List<Column> familyColumns(ResolvedSchema resolvedSchema) {
        return HTableInfo.columns(resolvedSchema).stream().filter(column -> column.getDataType().getLogicalType().getTypeRoot() == LogicalTypeRoot.ROW).collect(Collectors.toList());
    }

    public HTableInfo(@Nonnull TableId tableId, @Nonnull String rowKeyName, @Nonnull LogicalType rowKeyType, @Nonnull List<String> fieldNames, @Nonnull Map<String, String[]> columnNameMap, @Nonnull Map<String, LogicalType[]> columnTypeMap) {
        this.tableId = tableId;
        this.rowKeyName = rowKeyName;
        this.rowKeyType = rowKeyType;
        this.familyNames = fieldNames.stream().filter(s -> !rowKeyName.equals(s)).collect(Collectors.toList());
        this.columnNameMap = columnNameMap;
        this.columnTypeMap = columnTypeMap;
        this.fieldIndexMap = IntStream.range(0, fieldNames.size()).boxed().collect(Collectors.toMap(fieldNames::get, i -> i));
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public List<String> getKey() {
        return Collections.singletonList(this.rowKeyName);
    }

    public String getRowKeyName() {
        return this.rowKeyName;
    }

    public LogicalType getRowKeyType() {
        return this.rowKeyType;
    }

    public List<String> getFamilyNames() {
        return this.familyNames;
    }

    public String[] getColumnNames(String familyName) {
        return this.columnNameMap.get(familyName);
    }

    public LogicalType[] getColumnTypes(String familyName) {
        return this.columnTypeMap.get(familyName);
    }

    @Override
    public Integer getFieldIndex(String fieldName) {
        return this.fieldIndexMap.get(fieldName);
    }
}

