/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.table;

import com.oceanbase.connector.flink.table.DataChangeRecordData;
import com.oceanbase.connector.flink.table.Record;
import com.oceanbase.connector.flink.table.Table;
import com.oceanbase.connector.flink.table.TableId;
import java.io.Serializable;
import java.util.Optional;

public class DataChangeRecord
implements Record {
    private static final long serialVersionUID = 1L;
    private final Table table;
    private final Type type;
    private final DataChangeRecordData data;

    public DataChangeRecord(Table table, Type type, Object[] values) {
        this.table = table;
        this.type = type;
        this.data = new DataChangeRecordData(values);
    }

    @Override
    public TableId getTableId() {
        return this.table.getTableId();
    }

    public Table getTable() {
        return this.table;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isUpsert() {
        return Type.UPSERT == this.getType();
    }

    public Object getFieldValue(String fieldName) {
        return this.data.getValue(this.table.getFieldIndex(fieldName));
    }

    public String toString() {
        return "DataChangeRecord{table=" + this.table + ", type=" + (Object)((Object)this.type) + ", data=" + this.data + '}';
    }

    public static interface KeyExtractor
    extends Serializable {
        public Object extract(DataChangeRecord var1);

        public static KeyExtractor simple() {
            return record -> Optional.ofNullable(record.getTable().getKey()).map(keys -> new DataChangeRecordData(keys.stream().map(record::getFieldValue).toArray())).orElse(null);
        }
    }

    public static enum Type {
        UPSERT,
        DELETE;

    }
}

