/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.table;

import com.oceanbase.connector.flink.table.RecordSerializationSchema;
import com.oceanbase.connector.flink.table.SerializationRuntimeConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class AbstractRecordSerializationSchema<T>
implements RecordSerializationSchema<T> {
    private final Map<LogicalType, SerializationRuntimeConverter> converters = new ConcurrentHashMap<LogicalType, SerializationRuntimeConverter>();

    protected SerializationRuntimeConverter getOrCreateConverter(LogicalType type) {
        return this.converters.computeIfAbsent(type, this::createConverter);
    }

    protected abstract SerializationRuntimeConverter createNotNullConverter(LogicalType var1);

    private SerializationRuntimeConverter createConverter(LogicalType type) {
        return AbstractRecordSerializationSchema.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private static SerializationRuntimeConverter wrapIntoNullableConverter(final SerializationRuntimeConverter converter) {
        return new SerializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object data) {
                if (data == null) {
                    return null;
                }
                return converter.convert(data);
            }
        };
    }
}

