/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.sink;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.sink.DataStreamSinkProvider;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;

public abstract class AbstractDynamicTableSink
implements DynamicTableSink {
    protected final ResolvedSchema physicalSchema;

    public AbstractDynamicTableSink(ResolvedSchema physicalSchema) {
        this.physicalSchema = physicalSchema;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        this.validatePrimaryKey(requestedMode);
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).addContainedKind(RowKind.UPDATE_AFTER).build();
    }

    protected void validatePrimaryKey(ChangelogMode requestedMode) {
        Preconditions.checkState((ChangelogMode.insertOnly().equals((Object)requestedMode) || this.physicalSchema.getPrimaryKey().isPresent() ? 1 : 0) != 0, (Object)"please declare primary key for sink table when query contains update/delete record.");
    }

    static class SinkProvider
    implements DataStreamSinkProvider,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final SerializableFunction<TypeSerializer<RowData>, Sink<RowData>> sinkSupplier;

        public SinkProvider(SerializableFunction<TypeSerializer<RowData>, Sink<RowData>> sinkSupplier) {
            this.sinkSupplier = sinkSupplier;
        }

        public DataStreamSink<?> consumeDataStream(ProviderContext providerContext, DataStream<RowData> dataStream) {
            boolean objectReuse = dataStream.getExecutionEnvironment().getConfig().isObjectReuseEnabled();
            TypeSerializer typeSerializer = objectReuse ? dataStream.getType().createSerializer(dataStream.getExecutionConfig()) : null;
            return dataStream.sinkTo((Sink)this.sinkSupplier.apply((Object)typeSerializer));
        }
    }
}

