/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.dialect;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.dialect.OceanBaseDialect;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.function.SerializableFunction;

public class OceanBaseOracleDialect
implements OceanBaseDialect {
    private static final long serialVersionUID = 1L;
    private final OceanBaseConnectorOptions options;

    public OceanBaseOracleDialect(OceanBaseConnectorOptions options) {
        this.options = options;
    }

    @Override
    public String quoteIdentifier(@Nonnull String identifier) {
        if (Objects.isNull(this.options) || this.options.getTableOracleTenantCaseInsensitive()) {
            return identifier;
        }
        return "\"" + identifier + "\"";
    }

    @Override
    public String getUpsertStatement(@Nonnull String schemaName, @Nonnull String tableName, @Nonnull List<String> fieldNames, @Nonnull List<String> uniqueKeyFields, @Nullable SerializableFunction<String, String> placeholderFunc) {
        String sourceFields = fieldNames.stream().map(f -> this.getPlaceholder((String)f, placeholderFunc) + " AS " + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String onClause = uniqueKeyFields.stream().map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" and "));
        String updateClause = fieldNames.stream().filter(f -> !uniqueKeyFields.contains(f)).map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertFields = fieldNames.stream().map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesClause = fieldNames.stream().map(f -> "s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        return "MERGE INTO " + this.getFullTableName(schemaName, tableName) + " t  USING (SELECT " + sourceFields + " FROM DUAL) s  ON (" + onClause + ")  WHEN MATCHED THEN UPDATE SET " + updateClause + " WHEN NOT MATCHED THEN INSERT (" + insertFields + ") VALUES (" + valuesClause + ")";
    }

    @Override
    public String getSysDatabase() {
        return "SYS";
    }

    @Override
    public String getQueryTenantNameStatement() {
        return "SELECT SYS_CONTEXT('USERENV', 'CON_NAME') FROM DUAL";
    }
}

