/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.dialect;

import com.oceanbase.connector.flink.dialect.OceanBaseDialect;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.util.function.SerializableFunction;

public class OceanBaseMySQLDialect
implements OceanBaseDialect {
    private static final long serialVersionUID = 1L;

    @Override
    public String quoteIdentifier(@Nonnull String identifier) {
        return "`" + identifier.replaceAll("`", "``") + "`";
    }

    @Override
    public String getUpsertStatement(@Nonnull String schemaName, @Nonnull String tableName, @Nonnull List<String> fieldNames, @Nonnull List<String> uniqueKeyFields, @Nullable SerializableFunction<String, String> placeholderFunc) {
        String updateClause = fieldNames.stream().filter(f -> !uniqueKeyFields.contains(f)).map(f -> this.quoteIdentifier((String)f) + "=VALUES(" + this.quoteIdentifier((String)f) + ")").collect(Collectors.joining(", "));
        String insertIntoStatement = this.getInsertIntoStatement(schemaName, tableName, fieldNames, placeholderFunc);
        if (StringUtils.isNotEmpty((CharSequence)updateClause)) {
            return insertIntoStatement + " ON DUPLICATE KEY UPDATE " + updateClause;
        }
        return StringUtils.replace((String)insertIntoStatement, (String)"INSERT", (String)"INSERT IGNORE", (int)1);
    }

    @Override
    public String getSysDatabase() {
        return "oceanbase";
    }

    @Override
    public String getQueryTenantNameStatement() {
        return "SHOW TENANT";
    }
}

