/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.connection;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class OceanBaseUserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String cluster;
    private String tenant;
    private final String user;

    public OceanBaseUserInfo(String cluster, String tenant, String user) {
        this.cluster = cluster;
        this.tenant = tenant;
        this.user = user;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getUser() {
        return this.user;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public static OceanBaseUserInfo parse(String username) {
        String sepUserAtTenant = "@";
        String sepTenantAtCluster = "#";
        String sep = ":";
        int expectedSepCount = 2;
        if (username.contains("#") && username.contains("@")) {
            String[] parts = username.split("#");
            String[] userAndTenant = parts[0].split("@");
            return new OceanBaseUserInfo(parts[1], userAndTenant[1], userAndTenant[0]);
        }
        if (StringUtils.countMatches((CharSequence)username, (CharSequence)":") == 2) {
            String[] parts = username.split(":");
            return new OceanBaseUserInfo(parts[0], parts[1], parts[2]);
        }
        if (username.contains("@") && !username.contains("#")) {
            String[] parts = username.split("@");
            return new OceanBaseUserInfo(null, parts[1], parts[0]);
        }
        return new OceanBaseUserInfo(null, null, username);
    }
}

