/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.sink.OceanBaseDynamicTableSink;
import com.oceanbase.connector.flink.utils.OptionUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class OceanBaseDynamicTableSinkFactory
implements DynamicTableSinkFactory {
    public static final String IDENTIFIER = "oceanbase";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ResolvedSchema resolvedSchema = context.getCatalogTable().getResolvedSchema();
        ResolvedSchema physicalSchema = new ResolvedSchema(resolvedSchema.getColumns().stream().filter(Column::isPhysical).collect(Collectors.toList()), resolvedSchema.getWatermarkSpecs(), (UniqueConstraint)resolvedSchema.getPrimaryKey().orElse(null));
        Map options = context.getCatalogTable().getOptions();
        OptionUtils.printOptions(IDENTIFIER, options);
        return new OceanBaseDynamicTableSink(physicalSchema, new OceanBaseConnectorOptions(options));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(OceanBaseConnectorOptions.URL);
        options.add(OceanBaseConnectorOptions.USERNAME);
        options.add(OceanBaseConnectorOptions.PASSWORD);
        options.add(OceanBaseConnectorOptions.SCHEMA_NAME);
        options.add(OceanBaseConnectorOptions.TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(OceanBaseConnectorOptions.SYNC_WRITE);
        options.add(OceanBaseConnectorOptions.BUFFER_FLUSH_INTERVAL);
        options.add(OceanBaseConnectorOptions.BUFFER_SIZE);
        options.add(OceanBaseConnectorOptions.MAX_RETRIES);
        options.add(OceanBaseConnectorOptions.DRIVER_CLASS_NAME);
        options.add(OceanBaseConnectorOptions.DRUID_PROPERTIES);
        options.add(OceanBaseConnectorOptions.MEMSTORE_CHECK_ENABLED);
        options.add(OceanBaseConnectorOptions.MEMSTORE_THRESHOLD);
        options.add(OceanBaseConnectorOptions.MEMSTORE_CHECK_INTERVAL);
        options.add(OceanBaseConnectorOptions.PARTITION_ENABLED);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_ENABLED);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_HOST);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_PORT);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_PARALLEL);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_MAX_ERROR_ROWS);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_DUP_ACTION);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_TIMEOUT);
        options.add(OceanBaseConnectorOptions.DIRECT_LOAD_HEARTBEAT_TIMEOUT);
        return options;
    }
}

