/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink;

import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObLoadDupActionType;
import com.oceanbase.connector.flink.ConnectorOptions;
import com.oceanbase.connector.flink.utils.OptionUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class OceanBaseConnectorOptions
extends ConnectorOptions {
    private static final long serialVersionUID = 1L;
    public static final ConfigOption<String> DRIVER_CLASS_NAME = ConfigOptions.key((String)"driver-class-name").stringType().defaultValue((Object)"com.mysql.cj.jdbc.Driver").withDescription("JDBC driver class name, use 'com.mysql.cj.jdbc.Driver' by default.");
    public static final ConfigOption<String> DRUID_PROPERTIES = ConfigOptions.key((String)"druid-properties").stringType().noDefaultValue().withDescription("Properties for specific connection pool.");
    public static final ConfigOption<Boolean> MEMSTORE_CHECK_ENABLED = ConfigOptions.key((String)"memstore-check.enabled").booleanType().defaultValue((Object)true).withDescription("Whether enable memstore check. Default value is 'true'");
    public static final ConfigOption<Double> MEMSTORE_THRESHOLD = ConfigOptions.key((String)"memstore-check.threshold").doubleType().defaultValue((Object)0.9).withDescription("Memory usage threshold ratio relative to the limit value. Default value is '0.9'.");
    public static final ConfigOption<Duration> MEMSTORE_CHECK_INTERVAL = ConfigOptions.key((String)"memstore-check.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The check interval, over this time, the writer will check if memstore reaches threshold. Default value is '30s'.");
    public static final ConfigOption<Boolean> PARTITION_ENABLED = ConfigOptions.key((String)"partition.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable partition calculation and flush records by partitions. Default value is 'false'.");
    public static final ConfigOption<Boolean> DIRECT_LOAD_ENABLED = ConfigOptions.key((String)"direct-load.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable direct load.");
    public static final ConfigOption<String> DIRECT_LOAD_HOST = ConfigOptions.key((String)"direct-load.host").stringType().noDefaultValue().withDescription("Hostname used in direct load.");
    public static final ConfigOption<Integer> DIRECT_LOAD_PORT = ConfigOptions.key((String)"direct-load.port").intType().defaultValue((Object)2882).withDescription("Rpc port number used in direct load.");
    public static final ConfigOption<Integer> DIRECT_LOAD_PARALLEL = ConfigOptions.key((String)"direct-load.parallel").intType().defaultValue((Object)8).withDescription("Parallelism of direct load.");
    public static final ConfigOption<Long> DIRECT_LOAD_MAX_ERROR_ROWS = ConfigOptions.key((String)"direct-load.max-error-rows").longType().defaultValue((Object)0L).withDescription("Maximum tolerable number of error rows.");
    public static final ConfigOption<ObLoadDupActionType> DIRECT_LOAD_DUP_ACTION = ConfigOptions.key((String)"direct-load.dup-action").enumType(ObLoadDupActionType.class).defaultValue((Object)ObLoadDupActionType.REPLACE).withDescription("Action when there is duplicated record in direct load.");
    public static final ConfigOption<Duration> DIRECT_LOAD_TIMEOUT = ConfigOptions.key((String)"direct-load.timeout").durationType().defaultValue((Object)Duration.ofDays(7L)).withDescription("Timeout for direct load task.");
    public static final ConfigOption<Duration> DIRECT_LOAD_HEARTBEAT_TIMEOUT = ConfigOptions.key((String)"direct-load.heartbeat-timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("Client heartbeat timeout in direct load task.");
    public static final ConfigOption<Boolean> TABLE_ORACLE_TENANT_CASE_INSENSITIVE = ConfigOptions.key((String)"table.oracle-tenant-case-insensitive").booleanType().defaultValue((Object)true).withDescription("By default, under the Oracle tenant, schema names and column names are case-insensitive.");

    public OceanBaseConnectorOptions(Map<String, String> config) {
        super(config);
    }

    public String getDriverClassName() {
        return (String)this.allConfig.get(DRIVER_CLASS_NAME);
    }

    public Properties getDruidProperties() {
        return OptionUtils.parseProperties((String)this.allConfig.get(DRUID_PROPERTIES));
    }

    public boolean getMemStoreCheckEnabled() {
        return (Boolean)this.allConfig.get(MEMSTORE_CHECK_ENABLED);
    }

    public double getMemStoreThreshold() {
        return (Double)this.allConfig.get(MEMSTORE_THRESHOLD);
    }

    public long getMemStoreCheckInterval() {
        return ((Duration)this.allConfig.get(MEMSTORE_CHECK_INTERVAL)).toMillis();
    }

    public boolean getPartitionEnabled() {
        return (Boolean)this.allConfig.get(PARTITION_ENABLED);
    }

    public boolean getDirectLoadEnabled() {
        return (Boolean)this.allConfig.get(DIRECT_LOAD_ENABLED);
    }

    public String getDirectLoadHost() {
        return (String)this.allConfig.get(DIRECT_LOAD_HOST);
    }

    public int getDirectLoadPort() {
        return (Integer)this.allConfig.get(DIRECT_LOAD_PORT);
    }

    public int getDirectLoadParallel() {
        return (Integer)this.allConfig.get(DIRECT_LOAD_PARALLEL);
    }

    public long getDirectLoadMaxErrorRows() {
        return (Long)this.allConfig.get(DIRECT_LOAD_MAX_ERROR_ROWS);
    }

    public ObLoadDupActionType getDirectLoadDupAction() {
        return (ObLoadDupActionType)((Object)this.allConfig.get(DIRECT_LOAD_DUP_ACTION));
    }

    public long getDirectLoadTimeout() {
        return ((Duration)this.allConfig.get(DIRECT_LOAD_TIMEOUT)).toNanos() / 1000L;
    }

    public long getDirectLoadHeartbeatTimeout() {
        return ((Duration)this.allConfig.get(DIRECT_LOAD_HEARTBEAT_TIMEOUT)).toNanos() / 1000L;
    }

    public boolean getTableOracleTenantCaseInsensitive() {
        return (Boolean)this.allConfig.get(TABLE_ORACLE_TENANT_CASE_INSENSITIVE);
    }
}

