/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;

public abstract class ConnectorOptions
implements Serializable {
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The connection URL.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("The username.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("The password.");
    public static final ConfigOption<String> SCHEMA_NAME = ConfigOptions.key((String)"schema-name").stringType().noDefaultValue().withDescription("The schema name or database name.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The table name.");
    public static final ConfigOption<Boolean> SYNC_WRITE = ConfigOptions.key((String)"sync-write").booleanType().defaultValue((Object)false).withDescription("Whether to write synchronously.");
    public static final ConfigOption<Duration> BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("The flush interval, over this time, asynchronous threads will flush data. Default value is '1s'. If it's set to zero value like '0', scheduled flushing will be disabled.");
    public static final ConfigOption<Integer> BUFFER_SIZE = ConfigOptions.key((String)"buffer-flush.buffer-size").intType().defaultValue((Object)1000).withDescription("Buffer size. Default value is '1000'.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if writing records to database failed. Default value is '3'.");
    protected final ReadableConfig allConfig;

    public ConnectorOptions(Map<String, String> config) {
        this.allConfig = Configuration.fromMap(config);
    }

    public String getUrl() {
        return (String)this.allConfig.get(URL);
    }

    public String getUsername() {
        return (String)this.allConfig.get(USERNAME);
    }

    public String getPassword() {
        return (String)this.allConfig.get(PASSWORD);
    }

    public String getSchemaName() {
        return (String)this.allConfig.get(SCHEMA_NAME);
    }

    public String getTableName() {
        return (String)this.allConfig.get(TABLE_NAME);
    }

    public boolean getSyncWrite() {
        return (Boolean)this.allConfig.get(SYNC_WRITE);
    }

    public long getBufferFlushInterval() {
        return ((Duration)this.allConfig.get(BUFFER_FLUSH_INTERVAL)).toMillis();
    }

    public int getBufferSize() {
        return (Integer)this.allConfig.get(BUFFER_SIZE);
    }

    public int getMaxRetries() {
        return (Integer)this.allConfig.get(MAX_RETRIES);
    }
}

