/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.stream.ObTableQueryStreamResult;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.AbstractTableQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.HashMap;

public class ObTableQueryImpl
extends AbstractTableQueryImpl {
    private final String tableName;
    private ObTable table;
    private ObTableQueryRequest request;

    public ObTableQueryImpl(String tableName, ObTable table) {
        this.tableName = tableName;
        this.table = table;
        this.resetRequest();
    }

    private void resetRequest() {
        this.request = new ObTableQueryRequest();
        this.tableQuery = new ObTableQuery();
        this.request.setTableName(this.tableName);
        this.request.setTableQuery(this.tableQuery);
        this.request.setTableId(-1L);
        this.request.setPartitionId(0L);
    }

    @Override
    public QueryResultSet execute() throws Exception {
        HashMap<Long, ObPair<Long, ObTableParam>> partitionObTable = new HashMap<Long, ObPair<Long, ObTableParam>>();
        partitionObTable.put(0L, new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.table)));
        ObTableQueryStreamResult obTableQueryStreamResult = new ObTableQueryStreamResult();
        obTableQueryStreamResult.setTableQuery(this.tableQuery);
        obTableQueryStreamResult.setEntityType(this.entityType);
        obTableQueryStreamResult.setTableName(this.tableName);
        obTableQueryStreamResult.setExpectant(partitionObTable);
        obTableQueryStreamResult.setOperationTimeout(this.operationTimeout);
        obTableQueryStreamResult.init();
        return new QueryResultSet(obTableQueryStreamResult);
    }

    @Override
    public QueryResultSet executeInit(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeInit");
    }

    @Override
    public QueryResultSet executeNext(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeNext");
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public void clear() {
        this.resetRequest();
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public ObTable getTable() {
        return this.table;
    }

    public void resetObTable(ObTable obTable) {
        this.table = obTable;
    }
}

