/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ConcurrentTask;
import com.alipay.oceanbase.rpc.table.ConcurrentTaskExecutor;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ObTableClientBatchOpsImpl
extends AbstractTableBatchOps {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientBatchOpsImpl.class);
    private final ObTableClient obTableClient;
    private ExecutorService executorService;
    private boolean returningAffectedEntity = false;
    private ObTableBatchOperation batchOperation;

    public ObTableClientBatchOpsImpl(String tableName, ObTableClient obTableClient) {
        this.tableName = tableName;
        this.obTableClient = obTableClient;
        this.batchOperation = new ObTableBatchOperation();
    }

    public ObTableClientBatchOpsImpl(String tableName, ObTableBatchOperation batchOperation, ObTableClient obTableClient) {
        this.tableName = tableName;
        this.obTableClient = obTableClient;
        this.batchOperation = batchOperation;
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return this.batchOperation;
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        this.addObTableClientOperation(ObTableOperationType.GET, rowkeys, columns, null);
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableClientOperation(ObTableOperationType.UPDATE, rowkeys, columns, values);
    }

    @Override
    public void delete(Object[] rowkeys) {
        this.addObTableClientOperation(ObTableOperationType.DEL, rowkeys, null, null);
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableClientOperation(ObTableOperationType.INSERT, rowkeys, columns, values);
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableClientOperation(ObTableOperationType.REPLACE, rowkeys, columns, values);
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableClientOperation(ObTableOperationType.INSERT_OR_UPDATE, rowkeys, columns, values);
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.returningAffectedEntity = withResult;
        this.addObTableClientOperation(ObTableOperationType.INCREMENT, rowkeys, columns, values);
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.returningAffectedEntity = withResult;
        this.addObTableClientOperation(ObTableOperationType.APPEND, rowkeys, columns, values);
    }

    private void addObTableClientOperation(ObTableOperationType type, Object[] rowkeys, String[] columns, Object[] values) {
        ObTableOperation instance = ObTableOperation.getInstance(type, rowkeys, columns, values);
        this.batchOperation.addTableOperation(instance);
    }

    @Override
    public List<Object> execute() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.getTableOperations().size());
        block3: for (ObTableOperationResult result : this.executeInternal().getResults()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                switch (result.getOperationType()) {
                    case GET: 
                    case INCREMENT: 
                    case APPEND: {
                        results.add(result.getEntity().getSimpleProperties());
                        continue block3;
                    }
                }
                results.add(result.getAffectedRows());
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.getTableOperations().size());
        block3: for (ObTableOperationResult result : this.executeInternal().getResults()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                switch (result.getOperationType()) {
                    case GET: 
                    case INCREMENT: 
                    case APPEND: 
                    case INSERT: 
                    case DEL: 
                    case UPDATE: 
                    case INSERT_OR_UPDATE: 
                    case REPLACE: {
                        results.add(new MutationResult(result));
                        continue block3;
                    }
                }
                throw new ObTableException("unknown operation type " + (Object)((Object)result.getOperationType()));
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    public Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> partitionPrepare() throws Exception {
        List<ObTableOperation> operations = this.batchOperation.getTableOperations();
        HashMap<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> partitionOperationsMap = new HashMap<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>>();
        if (this.obTableClient.isOdpMode()) {
            ObPair obTableOperations = new ObPair(new ObTableParam(this.obTableClient.getOdpTable()), new ArrayList());
            for (int i = 0; i < operations.size(); ++i) {
                ObTableOperation operation = operations.get(i);
                ((List)obTableOperations.getRight()).add(new ObPair<Integer, ObTableOperation>(i, operation));
            }
            partitionOperationsMap.put(0L, obTableOperations);
            return partitionOperationsMap;
        }
        for (int i = 0; i < operations.size(); ++i) {
            ObTableOperation operation = operations.get(i);
            ObRowKey rowKeyObject = operation.getEntity().getRowKey();
            int rowKeySize = rowKeyObject.getObjs().size();
            Object[] rowKey = new Object[rowKeySize];
            for (int j = 0; j < rowKeySize; ++j) {
                rowKey[j] = rowKeyObject.getObj(j).getValue();
            }
            ObPair<Long, ObTableParam> tableObPair = this.obTableClient.getTable(this.tableName, rowKey, false, false, this.obTableClient.getRoute(this.batchOperation.isReadOnly()));
            ObPair obTableOperations = (ObPair)partitionOperationsMap.get(tableObPair.getLeft());
            if (obTableOperations == null) {
                obTableOperations = new ObPair(tableObPair.getRight(), new ArrayList());
                partitionOperationsMap.put(tableObPair.getLeft(), obTableOperations);
            }
            ((List)obTableOperations.getRight()).add(new ObPair<Integer, ObTableOperation>(i, operation));
        }
        if (this.atomicOperation && partitionOperationsMap.size() > 1) {
            throw new ObTablePartitionConsistentException("require atomic operation but found across partition may cause consistent problem ");
        }
        return partitionOperationsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partitionExecute(ObTableOperationResult[] results, Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> partitionOperation) throws Exception {
        ObTableBatchOperationResult subObTableBatchOperationResult;
        ObTableParam tableParam = partitionOperation.getValue().getLeft();
        long tableId = tableParam.getTableId();
        long partId = tableParam.getPartitionId();
        long originPartId = tableParam.getPartId();
        ObTable subObTable = tableParam.getObTable();
        List<ObPair<Integer, ObTableOperation>> subOperationWithIndexList = partitionOperation.getValue().getRight();
        ObTableBatchOperationRequest subRequest = new ObTableBatchOperationRequest();
        ObTableBatchOperation subOperations = new ObTableBatchOperation();
        for (ObPair<Integer, ObTableOperation> operationWithIndex : subOperationWithIndexList) {
            subOperations.addTableOperation(operationWithIndex.getRight());
        }
        subOperations.setSameType(this.batchOperation.isSameType());
        subOperations.setReadOnly(this.batchOperation.isReadOnly());
        subOperations.setSamePropertiesNames(this.batchOperation.isSamePropertiesNames());
        subRequest.setBatchOperation(subOperations);
        subRequest.setTableName(this.tableName);
        subRequest.setReturningAffectedEntity(this.returningAffectedEntity);
        subRequest.setReturningAffectedRows(true);
        subRequest.setTableId(tableId);
        subRequest.setPartitionId(partId);
        subRequest.setEntityType(this.entityType);
        subRequest.setTimeout(subObTable.getObTableOperationTimeout());
        if (this.batchOperation.isReadOnly()) {
            subRequest.setConsistencyLevel(this.obTableClient.getReadConsistency().toObTableConsistencyLevel());
        }
        subRequest.setBatchOperationAsAtomic(this.isAtomicOperation());
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        while (true) {
            this.obTableClient.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.obTableClient.getRuntimeMaxWait()) {
                logger.error("tablename:{} partition id:{} it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.obTableClient.getRuntimeMaxWait() + "/ms", (Object)this.tableName, (Object)partId);
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.obTableClient.getRuntimeMaxWait() + "/ms");
            }
            ++tryTimes;
            try {
                if (this.obTableClient.isOdpMode()) {
                    subObTable = this.obTableClient.getOdpTable();
                } else if (tryTimes > 1) {
                    if (route == null) {
                        route = this.obTableClient.getRoute(this.batchOperation.isReadOnly());
                    }
                    if (failedServerList != null) {
                        route.setBlackList(failedServerList);
                    }
                    subObTable = this.obTableClient.getTable(this.tableName, originPartId, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), route).getRight().getObTable();
                }
                subObTableBatchOperationResult = (ObTableBatchOperationResult)subObTable.execute(subRequest);
                this.obTableClient.resetExecuteContinuousFailureCount(this.tableName);
            }
            catch (Exception ex) {
                block28: {
                    if (this.obTableClient.isOdpMode()) {
                        if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                            throw ex;
                        }
                        logger.warn("batch ops execute while meet Exception, tablename:{}, errorCode: {} , errorMsg: {}, try times {}", new Object[]{this.tableName, ((ObTableException)ex).getErrorCode(), ex.getMessage(), tryTimes});
                    } else if (ex instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                            logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                            throw ex;
                        }
                        logger.warn("tablename:{} partition id:{} retry when replica not readable: {}", new Object[]{this.tableName, partId, ex.getMessage()});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else {
                        if (ex instanceof ObTableException && ((ObTableException)ex).isNeedRefreshTableEntry()) {
                            needRefreshTableEntry = true;
                            logger.warn("tablename:{} partition id:{} batch ops refresh table while meet ObTableMasterChangeException, errorCode: {}", new Object[]{this.tableName, partId, ((ObTableException)ex).getErrorCode(), ex});
                            if (this.obTableClient.isRetryOnChangeMasterTimes() && tryTimes - 1 < this.obTableClient.getRuntimeRetryTimes()) {
                                logger.warn("tablename:{} partition id:{} batch ops retry while meet ObTableMasterChangeException, errorCode: {} , retry times {}", new Object[]{this.tableName, partId, ((ObTableException)ex).getErrorCode(), tryTimes, ex});
                                break block28;
                            } else {
                                this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                                throw ex;
                            }
                        }
                        this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                        throw ex;
                    }
                }
                Thread.sleep(this.obTableClient.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
        long endExecute = System.currentTimeMillis();
        if (subObTableBatchOperationResult == null) {
            TableClientLoggerFactory.RUNTIME.error("tablename:{} partition id:{} check batch operation result error: client get unexpected NULL result", (Object)this.tableName, (Object)partId);
            throw new ObTableUnexpectedException("check batch operation result error: client get unexpected NULL result");
        }
        List<ObTableOperationResult> subObTableOperationResults = subObTableBatchOperationResult.getResults();
        if (subObTableOperationResults.size() < subOperations.getTableOperations().size()) {
            if (subObTableOperationResults.size() != 1) {
                throw new IllegalArgumentException("check batch operation result size error: operation size [" + subOperations.getTableOperations().size() + "] result size [" + subObTableOperationResults.size() + "]");
            }
            ObTableOperationResult subObTableOperationResult = subObTableOperationResults.get(0);
            subObTableOperationResult.setExecuteHost(subObTable.getIp());
            subObTableOperationResult.setExecutePort(subObTable.getPort());
            for (ObPair<Integer, ObTableOperation> aSubOperationWithIndexList : subOperationWithIndexList) {
                results[aSubOperationWithIndexList.getLeft().intValue()] = subObTableOperationResult;
            }
        } else {
            if (subOperationWithIndexList.size() != subObTableOperationResults.size()) {
                throw new ObTableUnexpectedException("check batch result error: partition " + partId + " expect result size " + subOperationWithIndexList.size() + " actual result size " + subObTableOperationResults.size());
            }
            for (int i = 0; i < subOperationWithIndexList.size(); ++i) {
                ObTableOperationResult subObTableOperationResult = subObTableOperationResults.get(i);
                subObTableOperationResult.setExecuteHost(subObTable.getIp());
                subObTableOperationResult.setExecutePort(subObTable.getPort());
                results[subOperationWithIndexList.get((int)i).getLeft().intValue()] = subObTableOperationResult;
            }
        }
        String endpoint = subObTable.getIp() + ":" + subObTable.getPort();
        MonitorUtil.info((ObPayload)subRequest, subObTable.getDatabase(), this.tableName, "BATCH-partitionExecute-", endpoint, subOperations, partId, subObTableOperationResults.size(), endExecute - startExecute, this.obTableClient.getslowQueryMonitorThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObTableBatchOperationResult executeInternal() throws Exception {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        long start = System.currentTimeMillis();
        List<ObTableOperation> operations = this.batchOperation.getTableOperations();
        final ObTableOperationResult[] obTableOperationResults = new ObTableOperationResult[operations.size()];
        Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> partitions = this.partitionPrepare();
        long getTableTime = System.currentTimeMillis();
        final Map<Object, Object> context = ThreadLocalMap.getContextMap();
        if (this.executorService != null && !this.executorService.isShutdown() && partitions.size() > 1) {
            final ConcurrentTaskExecutor executor = new ConcurrentTaskExecutor(this.executorService, partitions.size());
            for (final Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> entry : partitions.entrySet()) {
                executor.execute(new ConcurrentTask(){

                    @Override
                    public void doTask() {
                        try {
                            ThreadLocalMap.transmitContextMap(context);
                            ObTableClientBatchOpsImpl.this.partitionExecute(obTableOperationResults, entry);
                        }
                        catch (Exception e) {
                            logger.error(TableClientLoggerFactory.LCD.convert("01-00026"), (Throwable)e);
                            executor.collectExceptions(e);
                        }
                        finally {
                            ThreadLocalMap.reset();
                        }
                    }
                });
            }
            try {
                long nanos;
                for (long estimate = this.obTableClient.getRuntimeBatchMaxWait() * 1000L * 1000L; estimate > 0L; estimate -= System.nanoTime() - nanos) {
                    nanos = System.nanoTime();
                    try {
                        executor.waitComplete(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute interrupted", e);
                    }
                    if (executor.getThrowableList().size() > 0) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
                    }
                    if (!executor.isComplete()) continue;
                    break;
                }
            }
            finally {
                executor.stop();
            }
            if (executor.getThrowableList().size() > 0) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
            }
            if (!executor.isComplete()) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error [" + this.obTableClient.getRpcExecuteTimeout() + "]/ms");
            }
        } else {
            for (Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableOperation>>>> entry : partitions.entrySet()) {
                this.partitionExecute(obTableOperationResults, entry);
            }
        }
        ObTableBatchOperationResult batchOperationResult = new ObTableBatchOperationResult();
        for (ObTableOperationResult obTableOperationResult : obTableOperationResults) {
            batchOperationResult.addResult(obTableOperationResult);
        }
        MonitorUtil.info((ObPayload)batchOperationResult, this.obTableClient.getDatabase(), this.tableName, "BATCH", "", obTableOperationResults.length, getTableTime - start, System.currentTimeMillis() - getTableTime, this.obTableClient.getslowQueryMonitorThreshold());
        return batchOperationResult;
    }

    @Override
    public void clear() {
        this.batchOperation = new ObTableBatchOperation();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isReturningAffectedEntity() {
        return this.returningAffectedEntity;
    }

    public void setReturningAffectedEntity(boolean returningAffectedEntity) {
        this.returningAffectedEntity = returningAffectedEntity;
    }
}

