/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.stream.async;

import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.QueryStreamResult;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.ObTableClientQueryAsyncImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObTableQueryAsyncClientResultSet
implements QueryStreamResult {
    private final ObTableClientQueryAsyncImpl obTableClientQueryAsync;
    private QueryResultSet resultSet = null;
    private int resultSize;
    private int partitionIndex;
    private int cur;
    private List<ObPair<Long, ObTableParam>> lists;

    public ObTableQueryAsyncClientResultSet(ObTableClientQueryAsyncImpl obTableClientQueryAsync) throws Exception {
        this.obTableClientQueryAsync = obTableClientQueryAsync;
        Map<Long, ObPair<Long, ObTableParam>> expectant = this.obTableClientQueryAsync.getPartitions();
        this.partitionIndex = expectant.size() - 1;
        this.lists = new ArrayList<ObPair<Long, ObTableParam>>();
        for (Map.Entry<Long, ObPair<Long, ObTableParam>> obPairEntry : expectant.entrySet()) {
            this.lists.add(obPairEntry.getValue());
        }
    }

    @Override
    public boolean next() throws Exception {
        boolean res = false;
        if (this.cur < this.partitionIndex || this.partitionIndex == 0 || this.resultSet == null || this.resultSet.isHasMore()) {
            if (this.resultSet == null) {
                this.resultSet = this.obTableClientQueryAsync.getTableQuery().executeInit(this.lists.get(this.cur));
                this.resultSize = this.resultSet.cacheSize();
            }
            if (this.resultSet.isHasMore() && this.resultSize == 0) {
                this.resultSet = this.obTableClientQueryAsync.getTableQuery().executeNext(this.lists.get(this.cur));
                this.resultSize = this.resultSet.cacheSize();
                if (this.resultSize == 0 && this.cur < this.partitionIndex) {
                    ++this.cur;
                    this.resultSet = this.obTableClientQueryAsync.getTableQuery().executeInit(this.lists.get(this.cur));
                    this.resultSize = this.resultSet.cacheSize();
                }
            }
            if (this.resultSize == 0 && this.partitionIndex != 0) {
                do {
                    ++this.cur;
                    this.resultSet = this.obTableClientQueryAsync.getTableQuery().executeInit(this.lists.get(this.cur));
                    this.resultSize = this.resultSet.cacheSize();
                } while (this.resultSize == 0 && this.cur < this.partitionIndex);
            }
        }
        if (this.resultSize != 0) {
            res = this.resultSet.next();
        }
        return res;
    }

    @Override
    public List<ObObj> getRow() {
        List<ObObj> row = this.resultSet.getQueryStreamResult().getRow();
        --this.resultSize;
        return row;
    }

    @Override
    public int getRowIndex() {
        return this.resultSet.getQueryStreamResult().getRowIndex();
    }

    @Override
    public LinkedList<List<ObObj>> getCacheRows() {
        if (this.resultSet == null) {
            return new LinkedList<List<ObObj>>();
        }
        return this.resultSet.getQueryStreamResult().getCacheRows();
    }

    @Override
    public List<String> getCacheProperties() {
        return this.resultSet.getQueryStreamResult().getCacheProperties();
    }

    @Override
    public void init() throws Exception {
        this.resultSet.getQueryStreamResult().init();
    }

    @Override
    public void close() throws Exception {
        this.resultSet.getQueryStreamResult().close();
    }
}

