/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.stream;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.HashSet;
import org.slf4j.Logger;

public class ObTableClientQueryStreamResult
extends AbstractQueryStreamResult {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientQueryStreamResult.class);
    protected ObTableClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ObTableQueryResult execute(ObPair<Long, ObTableParam> partIdWithIndex, ObPayload request) throws Exception {
        ObPayload result;
        ObTable subObTable = partIdWithIndex.getRight().getObTable();
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        while (true) {
            this.client.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.client.getRuntimeMaxWait()) {
                long uniqueId = request.getUniqueId();
                long sequence = request.getSequence();
                String trace = String.format("Y%X-%016X", uniqueId, sequence);
                throw new ObTableTimeoutExcetion("[" + trace + "] has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.client.getRuntimeMaxWait() + "/ms");
            }
            ++tryTimes;
            try {
                if (tryTimes > 1) {
                    if (this.client.isOdpMode()) {
                        subObTable = this.client.getOdpTable();
                    } else {
                        if (route == null) {
                            route = this.client.getReadRoute();
                        }
                        if (failedServerList != null) {
                            route.setBlackList(failedServerList);
                        }
                        subObTable = this.client.getTable(this.indexTableName, partIdWithIndex.getLeft(), needRefreshTableEntry, this.client.isTableEntryRefreshIntervalWait(), route).getRight().getObTable();
                    }
                }
                result = subObTable.execute(request);
                this.client.resetExecuteContinuousFailureCount(this.indexTableName);
            }
            catch (Exception e) {
                block21: {
                    block22: {
                        if (!this.client.isOdpMode()) break block22;
                        if (tryTimes - 1 >= this.client.getRuntimeRetryTimes()) {
                            throw e;
                        }
                        if (e instanceof ObTableException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, errorCode: {}, errorMsg: {}, try times {}", new Object[]{this.indexTableName, ((ObTableException)e).getErrorCode(), e.getMessage(), tryTimes});
                            break block21;
                        } else if (e instanceof IllegalArgumentException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}, errorMsg: {}", new Object[]{this.indexTableName, tryTimes, e.getMessage()});
                            break block21;
                        } else {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}", new Object[]{this.indexTableName, tryTimes, e});
                        }
                        break block21;
                    }
                    if (e instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= this.client.getRuntimeRetryTimes()) {
                            logger.warn("tablename:{} partition id:{} exhaust retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                            throw e;
                        }
                        logger.warn("tablename:{} partition id:{} retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else {
                        if (e instanceof ObTableException && ((ObTableException)e).isNeedRefreshTableEntry()) {
                            needRefreshTableEntry = true;
                            logger.warn("tablename:{} partition id:{} stream query refresh table while meet Exception needing refresh, errorCode: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), e});
                            if (this.client.isRetryOnChangeMasterTimes() && tryTimes - 1 < this.client.getRuntimeRetryTimes()) {
                                logger.warn("tablename:{} partition id:{} stream query retry while meet Exception needing refresh, errorCode: {} , retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                                break block21;
                            } else {
                                this.client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                                throw e;
                            }
                        }
                        this.client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                        throw e;
                    }
                }
                Thread.sleep(this.client.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
        this.cacheStreamNext(partIdWithIndex, this.checkObTableQueryResult(result));
        return (ObTableQueryResult)result;
    }

    @Override
    protected ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        throw new IllegalArgumentException("not support this execute");
    }

    public ObTableClient getClient() {
        return this.client;
    }

    public void setClient(ObTableClient client) {
        this.client = client;
    }
}

