/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.parser;

import com.alipay.oceanbase.rpc.exception.GenerateColumnParseException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnReferFunc;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnSimpleFunc;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnSubStrFunc;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnFuncName;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnLexer;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnSimpleToken;
import java.math.BigInteger;
import java.util.ArrayList;

public class ObGeneratedColumnExpressParser {
    private final ObGeneratedColumnLexer lexer;

    public ObGeneratedColumnExpressParser(String text) {
        this.lexer = new ObGeneratedColumnLexer(text);
    }

    public ObGeneratedColumnSimpleFunc parse() throws GenerateColumnParseException {
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                String stringVal = this.lexer.stringVal();
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case EOF: {
                        return new ObGeneratedColumnReferFunc(stringVal);
                    }
                    case LPAREN: {
                        ObGeneratedColumnFuncName funcName = ObGeneratedColumnFuncName.funcToToken(stringVal.toLowerCase());
                        switch (funcName) {
                            case SUB_STR: {
                                ObGeneratedColumnSubStrFunc subStr = new ObGeneratedColumnSubStrFunc();
                                this.lexer.nextToken();
                                this.listParameters(subStr);
                                return subStr;
                            }
                        }
                        throw new GenerateColumnParseException("");
                    }
                }
                throw new GenerateColumnParseException("");
            }
        }
        throw new GenerateColumnParseException("ERROR. token :  " + (Object)((Object)this.lexer.token()) + ", pos : " + this.lexer.pos());
    }

    protected void listParameters(ObGeneratedColumnSimpleFunc func) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.primaryParameters());
        while (this.lexer.token() == ObGeneratedColumnSimpleToken.COMMA) {
            this.lexer.nextToken();
            args.add(this.primaryParameters());
        }
        this.accept(ObGeneratedColumnSimpleToken.RPAREN);
        if (func.getMinParameters() > args.size() || func.getMaxParameters() < args.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(args.get(i));
            }
            sb.append(")");
            throw new GenerateColumnParseException("illegal func args. expect size  " + func.getMinParameters() + "~" + func.getMaxParameters() + " but found" + sb.toString());
        }
        try {
            func.setParameters(args);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(args.get(i));
            }
            sb.append(")");
            throw new GenerateColumnParseException("illegal func args :" + sb.toString(), e);
        }
    }

    protected Object primaryParameters() {
        ObGeneratedColumnSimpleToken tok = this.lexer.token();
        switch (tok) {
            case IDENTIFIER: {
                String stringVal = this.lexer.stringVal();
                this.lexer.nextToken();
                return stringVal;
            }
            case LITERAL_HEX: {
                String hexStr = this.lexer.addSymbol();
                this.lexer.nextToken();
                return Long.parseLong(hexStr, 16);
            }
            case LITERAL_INT: {
                Number integerValue = this.lexer.integerValue();
                this.lexer.nextToken();
                return integerValue.longValue();
            }
            case SUB: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        long longVal;
                        int intVal;
                        Number integerValue = this.lexer.integerValue();
                        integerValue = integerValue instanceof Integer ? (Number)((intVal = integerValue.intValue()) == Integer.MIN_VALUE ? (Number)((long)intVal * -1L) : (Number)(intVal * -1)) : (Number)(integerValue instanceof Long ? ((longVal = ((Long)integerValue).longValue()) == 0x80000000L ? (Number)((int)(longVal * -1L)) : (Number)(longVal * -1L)) : ((BigInteger)integerValue).negate());
                        this.lexer.nextToken();
                        return integerValue.longValue();
                    }
                    case LITERAL_HEX: {
                        String hexStr = this.lexer.addSymbol();
                        this.lexer.nextToken();
                        return Long.parseLong(hexStr, 16) * -1L;
                    }
                }
                throw new GenerateColumnParseException("unsupported  token : " + tok.name + ", after - pos : " + this.lexer.pos());
            }
        }
        throw new GenerateColumnParseException("ERROR. token : " + (Object)((Object)tok) + ", pos : " + this.lexer.pos());
    }

    public void accept(ObGeneratedColumnSimpleToken token) {
        if (this.lexer.token() != token) {
            throw new GenerateColumnParseException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        this.lexer.nextToken();
    }
}

