/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.login;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableLoginResult
extends AbstractPayload {
    private int serverCapabilities;
    private int reversed1 = 0;
    private long reversed2 = 0L;
    private String serverVersion;
    private ObBytesString credential;
    private long tenantId;
    private long userId;
    private long databaseId;

    @Override
    public int getPcode() {
        return 4353;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.serverCapabilities);
        System.arraycopy(Serialization.encodeVi32(this.serverCapabilities), 0, bytes, idx += headerLen, len);
        idx += len;
        len = Serialization.getNeedBytes(this.reversed1);
        System.arraycopy(Serialization.encodeVi32(this.reversed1), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.reversed2);
        System.arraycopy(Serialization.encodeVi64(this.reversed2), 0, bytes, idx, len);
        byte[] strbytes = Serialization.encodeVString(this.serverVersion);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeBytesString(this.credential);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        len = Serialization.getNeedBytes(this.tenantId);
        System.arraycopy(Serialization.encodeVi64(this.tenantId), 0, bytes, idx += strbytes.length, len);
        idx += len;
        len = Serialization.getNeedBytes(this.userId);
        System.arraycopy(Serialization.encodeVi64(this.userId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.databaseId);
        System.arraycopy(Serialization.encodeVi64(this.databaseId), 0, bytes, idx, len);
        return bytes;
    }

    @Override
    public long getPayloadContentSize() {
        return Serialization.getNeedBytes(this.serverCapabilities) + Serialization.getNeedBytes(this.reversed1) + Serialization.getNeedBytes(this.reversed2) + Serialization.getNeedBytes(this.serverVersion) + Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tenantId) + Serialization.getNeedBytes(this.userId) + Serialization.getNeedBytes(this.databaseId);
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.serverCapabilities = Serialization.decodeVi32(buf);
        Serialization.decodeVi32(buf);
        Serialization.decodeVi64(buf);
        this.serverVersion = Serialization.decodeVString(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.tenantId = Serialization.decodeVi64(buf);
        this.userId = Serialization.decodeVi64(buf);
        this.databaseId = Serialization.decodeVi64(buf);
        return this;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setServerCapabilities(int serverCapabilities) {
        this.serverCapabilities = serverCapabilities;
    }

    public int getReversed1() {
        return this.reversed1;
    }

    public void setReversed1(int reversed1) {
        this.reversed1 = reversed1;
    }

    public long getReversed2() {
        return this.reversed2;
    }

    public void setReversed2(long reversed2) {
        this.reversed2 = reversed2;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public ObBytesString getCredential() {
        return this.credential;
    }

    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    @Override
    public long getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(long databaseId) {
        this.databaseId = databaseId;
    }
}

