/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation;

import com.alipay.oceanbase.rpc.ObClusterTableQuery;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationType;
import java.util.ArrayList;
import java.util.List;

public class ObTableAggregation {
    private List<String> message = new ArrayList<String>();
    private ObClusterTableQuery tablequery;

    public ObTableAggregation(ObClusterTableQuery obClusterTableQuery) {
        this.tablequery = obClusterTableQuery;
    }

    public void min(String columnName) {
        this.tablequery.addAggregation(ObTableAggregationType.MIN, columnName);
        this.message.add("min(" + columnName + ")");
    }

    public void min(String columnName, String aliasName) {
        this.tablequery.addAggregation(ObTableAggregationType.MIN, columnName);
        this.message.add("min(" + aliasName + ")");
    }

    public void max(String columnName) {
        this.tablequery.addAggregation(ObTableAggregationType.MAX, columnName);
        this.message.add("max(" + columnName + ")");
    }

    public void max(String columnName, String aliasName) {
        this.tablequery.addAggregation(ObTableAggregationType.MAX, columnName);
        this.message.add("max(" + aliasName + ")");
    }

    public void count() {
        this.tablequery.addAggregation(ObTableAggregationType.COUNT, "*");
        this.message.add("count(*)");
    }

    public void count(String aliasName) {
        this.tablequery.addAggregation(ObTableAggregationType.COUNT, "*");
        this.message.add("count(" + aliasName + ")");
    }

    public void sum(String columnName) {
        this.tablequery.addAggregation(ObTableAggregationType.SUM, columnName);
        this.message.add("sum(" + columnName + ")");
    }

    public void sum(String columnName, String aliasName) {
        this.tablequery.addAggregation(ObTableAggregationType.SUM, columnName);
        this.message.add("sum(" + aliasName + ")");
    }

    public void avg(String columnName) {
        this.tablequery.addAggregation(ObTableAggregationType.AVG, columnName);
        this.message.add("avg(" + columnName + ")");
    }

    public void avg(String columnName, String aliasName) {
        this.tablequery.addAggregation(ObTableAggregationType.AVG, columnName);
        this.message.add("avg(" + aliasName + ")");
    }

    public void setScanRangeColumns(String ... columns) {
        this.tablequery.setScanRangeColumns(columns);
    }

    public void addScanRange(Object start, Object end) {
        this.tablequery.addScanRange(start, end);
    }

    public void addScanRange(Object[] start, Object[] end) {
        this.tablequery.addScanRange(start, end);
    }

    public void indexName(String indexName) {
        this.tablequery.indexName(indexName);
    }

    public void setFilter(ObTableFilter filter) {
        this.tablequery.setFilter(filter);
    }

    public void limit(int offset, int limit) {
        this.tablequery.limit(offset, limit);
    }

    public void setOperationTimeout(long operationTimeout) {
        this.tablequery.setOperationTimeout(operationTimeout);
    }

    public ObTableAggregationResult execute() throws Exception {
        if (this.message.size() == 0) {
            throw new IllegalArgumentException("please add aggregations.");
        }
        this.tablequery.select(this.message.toArray(new String[this.message.size()]));
        return new ObTableAggregationResult(this.tablequery.execute());
    }
}

