/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpResult;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObTableTabletOpResult
extends AbstractPayload {
    private List<ObTableSingleOpResult> results = new ArrayList<ObTableSingleOpResult>();
    private List<String> propertiesColumnNames = new ArrayList<String>();

    @Override
    public int getPcode() {
        return 4389;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.results.size());
        System.arraycopy(Serialization.encodeVi64(this.results.size()), 0, bytes, idx += headerLen, len);
        idx += len;
        for (ObTableSingleOpResult result : this.results) {
            len = (int)result.getPayloadSize();
            System.arraycopy(result.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        int len = (int)Serialization.decodeVi64(buf);
        this.results = new ArrayList<ObTableSingleOpResult>(len);
        for (int i = 0; i < len; ++i) {
            ObTableSingleOpResult obTableSingleOpResult = new ObTableSingleOpResult();
            obTableSingleOpResult.setPropertiesColumnNames(this.propertiesColumnNames);
            obTableSingleOpResult.decode(buf);
            this.results.add(obTableSingleOpResult);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.results.size());
        for (ObTableSingleOpResult result : this.results) {
            payloadContentSize += result.getPayloadSize();
        }
        return payloadContentSize;
    }

    public List<ObTableSingleOpResult> getResults() {
        return this.results;
    }

    public void setResults(List<ObTableSingleOpResult> results) {
        this.results = results;
    }

    public void addResult(ObTableSingleOpResult result) {
        this.results.add(result);
    }

    public void setPropertiesColumnNames(List<String> propertiesColumnNames) {
        this.propertiesColumnNames = propertiesColumnNames;
    }
}

