/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObTableBatchOperation
extends AbstractPayload {
    private List<ObTableOperation> tableOperations = new ArrayList<ObTableOperation>();
    private boolean isReadOnly = true;
    private boolean isSameType = true;
    private boolean isSamePropertiesNames;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.tableOperations.size());
        System.arraycopy(Serialization.encodeVi64(this.tableOperations.size()), 0, bytes, idx += headerLen, len);
        idx += len;
        for (ObTableOperation tableOperation : this.tableOperations) {
            len = (int)tableOperation.getPayloadSize();
            System.arraycopy(tableOperation.encode(), 0, bytes, idx, len);
            idx += len;
        }
        System.arraycopy(Serialization.encodeI8(this.isReadOnly ? (byte)1 : 0), 0, bytes, idx, 1);
        System.arraycopy(Serialization.encodeI8(this.isSameType ? (byte)1 : 0), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.isSamePropertiesNames ? (byte)1 : 0), 0, bytes, ++idx, 1);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        int len = (int)Serialization.decodeVi64(buf);
        this.tableOperations = new ArrayList<ObTableOperation>(len);
        for (int i = 0; i < len; ++i) {
            ObTableOperation obTableOperation = new ObTableOperation();
            obTableOperation.decode(buf);
            this.tableOperations.add(obTableOperation);
        }
        this.isReadOnly = Serialization.decodeI8(buf) == 1;
        this.isSameType = Serialization.decodeI8(buf) == 1;
        this.isSamePropertiesNames = Serialization.decodeI8(buf) == 1;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.tableOperations.size());
        for (ObTableOperation operation : this.tableOperations) {
            payloadContentSize += operation.getPayloadSize();
        }
        return payloadContentSize + 3L;
    }

    public List<ObTableOperation> getTableOperations() {
        return this.tableOperations;
    }

    public void addTableOperation(ObTableOperation tableOperation) {
        this.tableOperations.add(tableOperation);
        int length = this.tableOperations.size();
        if (this.isReadOnly && !tableOperation.isReadonly()) {
            this.isReadOnly = false;
        }
        if (this.isSameType && length > 1 && this.tableOperations.get(length - 1).getOperationType() != this.tableOperations.get(length - 2).getOperationType()) {
            this.isSameType = false;
        }
    }

    public void setTableOperations(List<ObTableOperation> tableOperations) {
        this.tableOperations = tableOperations;
        this.isReadOnly = true;
        this.isSameType = true;
        ObTableOperationType prevType = null;
        for (ObTableOperation o : tableOperations) {
            if (this.isReadOnly || this.isSameType) {
                if (!o.isReadonly()) {
                    this.isReadOnly = false;
                }
                if (prevType != null && prevType != o.getOperationType()) {
                    this.isSameType = false;
                    continue;
                }
                prevType = o.getOperationType();
                continue;
            }
            return;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isSameType() {
        return this.isSameType;
    }

    public void setSameType(boolean sameType) {
        this.isSameType = sameType;
    }

    public boolean isSamePropertiesNames() {
        return this.isSamePropertiesNames;
    }

    public void setSamePropertiesNames(boolean samePropertiesNames) {
        this.isSamePropertiesNames = samePropertiesNames;
    }
}

