/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class ObRowKey {
    private List<ObObj> objs = new ArrayList<ObObj>();

    public long getObjCount() {
        return this.objs.size();
    }

    public List<ObObj> getObjs() {
        return this.objs;
    }

    public void setObjs(List<ObObj> objs) {
        this.objs = objs;
    }

    public ObObj getObj(int idx) {
        return this.objs.get(idx);
    }

    public void setObj(int idx, ObObj obObj) {
        this.objs.set(idx, obObj);
    }

    public void addObj(ObObj obObj) {
        this.objs.add(obObj);
    }

    public static ObRowKey getInstance(ObObj ... values) {
        ObRowKey rowKey = new ObRowKey();
        for (ObObj value : values) {
            rowKey.addObj(value);
        }
        return rowKey;
    }

    public static ObRowKey getInstance(Object ... values) {
        ObRowKey rowKey = new ObRowKey();
        for (Object value : values) {
            if (value instanceof ObObj) {
                rowKey.addObj((ObObj)value);
                continue;
            }
            rowKey.addObj(ObObj.getInstance(value));
        }
        return rowKey;
    }

    public static ObRowKey getInstance(List<Object> values) {
        ObRowKey rowKey = new ObRowKey();
        for (Object value : values) {
            if (value instanceof ObObj) {
                rowKey.addObj((ObObj)value);
                continue;
            }
            rowKey.addObj(ObObj.getInstance(value));
        }
        return rowKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObRowKey obRowKey = (ObRowKey)o;
        return Objects.equal(this.objs, obRowKey.objs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.objs});
    }
}

