/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.api.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Insert
extends Mutation<Insert> {
    private List<String> columns = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();

    public Insert() {
    }

    public Insert(Table client, String tableName) {
        super(client, tableName);
    }

    @Override
    public Insert setRowKey(Row rowKey) {
        return (Insert)this.setRowKeyOnly(rowKey);
    }

    @Override
    public Insert setRowKey(ColumnValue ... rowKey) {
        return (Insert)this.setRowKeyOnly(rowKey);
    }

    @Override
    public Insert setFilter(ObTableFilter filter) throws Exception {
        return (Insert)this.setFilterOnly(filter);
    }

    @Override
    public ObTableOperationType getOperationType() {
        return ObTableOperationType.INSERT;
    }

    public Insert addMutateRow(Row rows) {
        if (null == rows) {
            throw new IllegalArgumentException("Invalid null rowKey set into Insert");
        }
        if (0 == rows.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        for (Map.Entry<String, Object> entry : rows.getMap().entrySet()) {
            this.columns.add(entry.getKey());
            this.values.add(entry.getValue());
        }
        return this;
    }

    public String[] getColumns() {
        return this.columns.toArray(new String[0]);
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    public Insert addMutateColVal(ColumnValue ... columnValues) throws Exception {
        if (null == columnValues) {
            throw new IllegalArgumentException("Invalid null columnValues set into Insert");
        }
        for (ColumnValue columnValue : columnValues) {
            if (this.columns.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            this.columns.add(columnValue.getColumnName());
            this.values.add(columnValue.getValue());
        }
        return this;
    }

    public Insert removeRowkeyFromMutateColval() {
        Insert.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        return this;
    }

    public MutationResult execute() throws Exception {
        if (null == this.getTableName() || this.getTableName().isEmpty()) {
            throw new ObTableException("table name is null");
        }
        if (null == this.getClient()) {
            throw new ObTableException("client is null");
        }
        Insert.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        if (null == this.getQuery()) {
            return new MutationResult(((ObTableClient)this.getClient()).insertWithResult(this.getTableName(), this.getRowKey(), this.getKeyRanges(), this.columns.toArray(new String[0]), this.values.toArray()));
        }
        if (this.checkMutationWithFilter()) {
            ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.INSERT, this.getRowKey(), this.columns.toArray(new String[0]), this.values.toArray());
            return new MutationResult(((ObTableClient)this.getClient()).mutationWithFilter(this.getQuery(), this.getRowKey(), this.getKeyRanges(), operation, true));
        }
        throw new ObTableUnexpectedException("should set filter and scan range both");
    }
}

