/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import java.util.Arrays;
import java.util.List;

public class ObPartitionKey
implements Comparable<ObPartitionKey> {
    public static final Comparable MAX_PARTITION_ELEMENT = new Comparable(){

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            return 1;
        }
    };
    public static final Comparable MIN_PARTITION_ELEMENT = new Comparable(){

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }
    };
    private final List<Comparable> partitionElements;
    private final List<ObColumn> orderPartColumns;

    public List<Comparable> getPartitionElements() {
        return this.partitionElements;
    }

    public List<ObColumn> getOrderPartColumns() {
        return this.orderPartColumns;
    }

    public ObPartitionKey(List<ObColumn> orderPartColumns, List<Comparable> partitionElements) throws IllegalArgumentException {
        if (orderPartColumns == null || partitionElements == null) {
            throw new IllegalArgumentException("orderPartColumns is null or partitionElements is null");
        }
        if (orderPartColumns.size() != partitionElements.size()) {
            throw new IllegalArgumentException("the size of orderPartColumns is not same as the size of partitionElements ");
        }
        this.orderPartColumns = orderPartColumns;
        this.partitionElements = partitionElements;
    }

    @Override
    public int compareTo(ObPartitionKey that) {
        if (this.partitionElements.size() != that.partitionElements.size()) {
            throw new ClassCastException("size not equal" + this.partitionElements + that.partitionElements);
        }
        for (int i = 0; i < this.partitionElements.size(); ++i) {
            int tmpRet;
            Comparable thatElement;
            Comparable thisElement = this.partitionElements.get(i);
            if (thisElement == (thatElement = that.partitionElements.get(i))) continue;
            if (thisElement == MAX_PARTITION_ELEMENT || thatElement == MIN_PARTITION_ELEMENT) {
                return 1;
            }
            if (thatElement == MAX_PARTITION_ELEMENT || thisElement == MIN_PARTITION_ELEMENT) {
                return -1;
            }
            if (this.orderPartColumns.get(i).getObCollationType() == ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI) {
                if (!(thisElement instanceof String) || !(thatElement instanceof String)) {
                    throw new IllegalArgumentException("CS_TYPE_UTF8MB4_GENERAL_CI only allow string compare");
                }
                tmpRet = ((String)((Object)thisElement)).toUpperCase().compareTo(((String)((Object)thatElement)).toUpperCase());
            } else {
                if (thisElement instanceof Number && thatElement instanceof Number) {
                    thisElement = Long.valueOf(((Number)((Object)thisElement)).longValue());
                    thatElement = Long.valueOf(((Number)((Object)thatElement)).longValue());
                }
                tmpRet = thisElement.compareTo(thatElement);
            }
            if (0 == tmpRet) continue;
            return tmpRet;
        }
        return 0;
    }

    public static ObPartitionKey getInstance(List<ObColumn> orderPartColumns, Comparable ... rowKeyElements) {
        return new ObPartitionKey(orderPartColumns, Arrays.asList(rowKeyElements));
    }

    public static ObPartitionKey getInstance(List<ObColumn> orderPartColumns, List<Comparable> rowKeyElements) {
        return new ObPartitionKey(orderPartColumns, rowKeyElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObPartitionKey that = (ObPartitionKey)o;
        if (this.partitionElements.size() != that.partitionElements.size()) {
            return false;
        }
        for (int i = 0; i < this.partitionElements.size(); ++i) {
            Comparable thatElement;
            Comparable thisElement = this.partitionElements.get(i);
            if (thisElement == (thatElement = this.partitionElements.get(i))) continue;
            if (this.orderPartColumns.get(i).getObCollationType() == ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI) {
                if (thisElement == MAX_PARTITION_ELEMENT || thisElement == MIN_PARTITION_ELEMENT || thatElement == MAX_PARTITION_ELEMENT || thatElement == MIN_PARTITION_ELEMENT) {
                    return false;
                }
                if (!(thisElement instanceof String) || !(thatElement instanceof String)) {
                    throw new IllegalArgumentException("CS_TYPE_UTF8MB4_GENERAL_CI only allow string compare");
                }
                if (!((String)((Object)thisElement)).equalsIgnoreCase((String)((Object)thatElement))) {
                    return false;
                }
            }
            if (thisElement.equals(thatElement)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.partitionElements.size(); ++i) {
            Comparable thisElement = this.partitionElements.get(i);
            if (thisElement == MAX_PARTITION_ELEMENT || thisElement == MIN_PARTITION_ELEMENT) {
                hashCode = 31 * hashCode + thisElement.hashCode();
                continue;
            }
            if (this.orderPartColumns.get(i).getObCollationType() != ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI) continue;
            if (!(thisElement instanceof String)) {
                throw new IllegalArgumentException("CS_TYPE_UTF8MB4_GENERAL_CI only allow string compare");
            }
            hashCode = 31 * hashCode + ((String)((Object)thisElement)).toUpperCase().hashCode();
        }
        return hashCode;
    }
}

