/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObListPartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObListPartDesc.class);
    private List<ObColumn> orderCompareColumns = null;
    private Map<ObPartitionKey, Long> sets = null;

    public ObListPartDesc() {
        this.setPartFuncType(ObPartFuncType.LIST);
    }

    public List<ObColumn> getOrderCompareColumns() {
        return this.orderCompareColumns;
    }

    public void setOrderCompareColumns(List<ObColumn> columns) {
        this.orderCompareColumns = columns;
    }

    public void setSets(Map<ObPartitionKey, Long> sets) {
        this.sets = sets;
    }

    public Map<ObPartitionKey, Long> getSets() {
        return this.sets;
    }

    @Override
    public Long getRandomPartId() {
        if (null == this.sets) {
            return null;
        }
        int randomIndex = RandomUtil.getRandomNum(0, this.sets.size());
        return (Long)this.sets.values().toArray()[randomIndex];
    }

    @Override
    public void prepare() throws IllegalArgumentException {
        if (this.sets == null || this.sets.size() == 0) {
            throw new IllegalArgumentException("prepare ObListPartDesc failed . partition set is empty " + this.sets);
        }
        if (this.orderCompareColumns == null || this.orderCompareColumns.size() == 0) {
            throw new IllegalArgumentException("prepare ObListPartDesc failed . orderCompareColumns set is empty " + this.orderCompareColumns);
        }
        super.prepare();
    }

    @Override
    public List<Long> getPartIds(Object[] start, boolean startInclusive, Object[] end, boolean endInclusive) {
        ArrayList<Object[]> rowKeys = new ArrayList<Object[]>();
        rowKeys.add(start);
        rowKeys.add(end);
        Long partId = this.getPartId(rowKeys, true);
        ArrayList<Long> partIds = new ArrayList<Long>();
        partIds.add(partId);
        return partIds;
    }

    @Override
    public Long getPartId(Object ... rowKey) {
        ArrayList<Object[]> rowKeys = new ArrayList<Object[]>();
        rowKeys.add(rowKey);
        return this.getPartId(rowKeys, false);
    }

    @Override
    public Long getPartId(List<Object[]> rowKeys, boolean consistency) {
        if (rowKeys == null || rowKeys.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rowKeys);
        }
        try {
            Long partId = null;
            for (Object[] rowKey : rowKeys) {
                List<Object> currentRowKeyEvalValues = this.evalRowKeyValues(rowKey);
                List<Comparable> values = super.initComparableElementByTypes(currentRowKeyEvalValues, this.orderCompareColumns);
                ObPartitionKey searchKey = ObPartitionKey.getInstance(this.orderCompareColumns, values);
                long currentPartId = this.sets.get(searchKey);
                if (partId == null) {
                    partId = currentPartId;
                }
                if (!consistency) break;
                if (partId == currentPartId) continue;
                throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rowKeys);
            }
            return partId;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00001"), (Throwable)e);
            throw new IllegalArgumentException("ObListPartDesc get part id come across illegal params", e);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("orderCompareColumns", this.orderCompareColumns).append("sets", this.sets).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }

    @Override
    public void setPartNum(int n) {
    }
}

