/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.util.ObHashUtils;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObKeyPartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObKeyPartDesc.class);
    private List<Long> completeWorks;
    private int partSpace = 0;
    private int partNum = 0;

    public ObKeyPartDesc() {
        this.setPartFuncType(ObPartFuncType.KEY);
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }

    @Override
    public void setPartNum(int partNum) {
        this.partNum = partNum;
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (long i = 0L; i < (long)partNum; ++i) {
            partIds.add(i);
        }
        this.completeWorks = Collections.unmodifiableList(partIds);
    }

    @Override
    public List<Long> getPartIds(Object[] start, boolean startInclusive, Object[] end, boolean endInclusive) {
        try {
            List<Object> startValues = this.evalRowKeyValues(start);
            List<Object> endValues = this.evalRowKeyValues(end);
            if (startValues == null || endValues == null) {
                throw new NumberFormatException("can not parseToComparable start value [" + startValues + "] or end value [" + endValues + "] to long");
            }
            if (startValues.equals(endValues)) {
                ArrayList<Object[]> rowKeys = new ArrayList<Object[]>();
                ArrayList<Long> partIds = new ArrayList<Long>();
                rowKeys.add(start);
                partIds.add(this.getPartId(rowKeys, false));
                return partIds;
            }
            return this.completeWorks;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00002"), (Throwable)e);
            throw new IllegalArgumentException("ObKeyPartDesc get part id come across illegal params", e);
        }
    }

    @Override
    public Long getRandomPartId() {
        return this.partNum > 0 ? Long.valueOf(RandomUtil.getRandomNum(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object ... rowKey) throws IllegalArgumentException {
        ArrayList<Object[]> rowKeys = new ArrayList<Object[]>();
        rowKeys.add(rowKey);
        return this.getPartId(rowKeys, false);
    }

    @Override
    public Long getPartId(List<Object[]> rowKeys, boolean consistency) {
        if (rowKeys == null || rowKeys.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rowKeys);
        }
        try {
            int partRefColumnSize = this.orderedPartRefColumnRowKeyRelations.size();
            List<Object> evalValues = null;
            for (Object[] rowKey : rowKeys) {
                List<Object> currentRowKeyEvalValues = this.evalRowKeyValues(rowKey);
                if (evalValues == null) {
                    evalValues = currentRowKeyEvalValues;
                }
                if (!consistency) break;
                if (evalValues == currentRowKeyEvalValues) continue;
                for (int i = 0; i < evalValues.size(); ++i) {
                    if (this.equalsWithCollationType(((ObColumn)((ObPair)this.orderedPartRefColumnRowKeyRelations.get(i)).getLeft()).getObCollationType(), evalValues.get(i), currentRowKeyEvalValues.get(i))) continue;
                    throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rowKeys);
                }
            }
            long hashValue = 0L;
            for (int i = 0; i < partRefColumnSize; ++i) {
                hashValue = ObHashUtils.toHashcode(evalValues.get(i), (ObColumn)((ObPair)this.orderedPartRefColumnRowKeyRelations.get(i)).getLeft(), hashValue, this.getPartFuncType());
            }
            hashValue = hashValue > 0L ? hashValue : -hashValue;
            return (long)this.partSpace << 28 | hashValue % (long)this.partNum;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00023"), (Throwable)e);
            throw new IllegalArgumentException("ObKeyPartDesc get part id come across illegal params", e);
        }
    }

    private boolean equalsWithCollationType(ObCollationType collationType, Object s, Object t) throws IllegalArgumentException {
        if (collationType == ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI) {
            if (!(s instanceof String) || !(t instanceof String)) {
                throw new IllegalArgumentException("CS_TYPE_UTF8MB4_GENERAL_CI only allow string equal");
            }
            return ((String)s).equalsIgnoreCase((String)t);
        }
        return s.equals(t);
    }

    @Override
    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        if (rowKeyElement == null || rowKeyElement.size() == 0) {
            throw new IllegalArgumentException("ObKeyPartDesc rowKeyElement is empty");
        }
        super.setRowKeyElement(rowKeyElement);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partSpace", this.partSpace).append("partNum", this.partNum).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }
}

