/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.filter;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObCompareOp;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;

public class ObTableValueFilter
extends ObTableFilter {
    private ObCompareOp op;
    private String columnName;
    private Object value;

    public ObTableValueFilter(ObCompareOp op, String columnName, Object value) throws ObTableException {
        if (op == ObCompareOp.IS || op == ObCompareOp.IS_NOT) {
            if (value != null) {
                throw new ObTableException(String.format("the value of compare op %s must be null", op.toString()));
            }
        } else if (value == null) {
            throw new ObTableException(String.format("the value of comparer op %s must not be null", op.toString()));
        }
        this.op = op;
        this.columnName = columnName;
        this.value = value;
    }

    public void set(ObCompareOp op, String columnName, Object value) throws ObTableException {
        if (op == ObCompareOp.IS || op == ObCompareOp.IS_NOT) {
            if (value != null) {
                throw new ObTableException(String.format("the value of %s must be null", op.toString()));
            }
        } else if (value == null) {
            throw new ObTableException(String.format("the value of %s must not be null", op.toString()));
        }
        this.op = op;
        this.columnName = columnName;
        this.value = value;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String toString() {
        StringBuilder filterString = new StringBuilder();
        if (null == this.op || null == this.columnName || this.columnName.isEmpty()) {
            return null;
        }
        filterString.append("TableCompareFilter");
        filterString.append("(");
        filterString.append(this.op.toString());
        filterString.append(", '");
        filterString.append(this.columnName);
        filterString.append(":");
        if (this.value != null) {
            filterString.append(String.valueOf(this.value));
        }
        filterString.append("')");
        return filterString.toString();
    }
}

