/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.exception;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableTransportException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import java.util.Objects;

public class ExceptionUtil {
    public static void throwObTableException(int errorCode) {
        if (errorCode != ResultCodes.OB_SUCCESS.errorCode) {
            throw ExceptionUtil.convertToObTableException("", 0, 0L, 0L, errorCode, "");
        }
    }

    public static void throwObTableException(String host, int port, long sequence, long uniqueId, int errorCode, String errorMessage) {
        if (errorCode != ResultCodes.OB_SUCCESS.errorCode) {
            throw ExceptionUtil.convertToObTableException(host, port, sequence, uniqueId, errorCode, errorMessage);
        }
    }

    public static ObTableException convertToObTableException(String host, int port, long sequence, long uniqueId, int errorCode, String errorMessage) {
        String trace = String.format("Y%X-%016X", uniqueId, sequence);
        String server = host + ":" + port;
        String errMsg = Objects.equals(errorMessage, "") ? "error occur in server" : errorMessage;
        ResultCodes resultCodes = ResultCodes.valueOf(errorCode);
        if (resultCodes == null) {
            return new ObTableUnexpectedException("[" + trace + "] [unknown errcode: " + errorCode + "] server [" + server + "]", errorCode);
        }
        return new ObTableException("[" + String.valueOf(resultCodes.errorCode) + "][" + resultCodes.name() + "][" + errMsg + "][" + server + "][" + trace + "]", resultCodes.errorCode);
    }

    public static void throwObTableTransportException(String message, int errorCode) {
        switch (errorCode) {
            case 0: {
                return;
            }
            case -20004: 
            case -20003: 
            case -20002: 
            case -20001: {
                throw new ObTableTransportException(message, errorCode);
            }
        }
        throw new ObTableTransportException("unexpected transport exception: " + errorCode, errorCode);
    }
}

