/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class SQLBinaryOpExprGroup
extends SQLExprImpl
implements SQLReplaceable {
    private final SQLBinaryOperator operator;
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    private DbType dbType;

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator2) {
        this.operator = operator2;
    }

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator2, DbType dbType) {
        this.operator = operator2;
        this.dbType = dbType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLBinaryOpExprGroup that = (SQLBinaryOpExprGroup)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.items.equals(that.items);
    }

    @Override
    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + this.items.hashCode();
        return result;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (int i = 0; i < this.items.size(); ++i) {
                SQLExpr item = this.items.get(i);
                item.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLExpr clone() {
        SQLBinaryOpExprGroup x = new SQLBinaryOpExprGroup(this.operator);
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(this);
            x.items.add(item2);
        }
        return x;
    }

    public List getChildren() {
        return this.items;
    }

    public void add(SQLExpr item) {
        this.add(this.items.size(), item);
    }

    public void add(int index, SQLExpr item) {
        if (item instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
            if (binaryOpExpr.getOperator() == this.operator) {
                this.add(binaryOpExpr.getLeft());
                this.add(binaryOpExpr.getRight());
                return;
            }
        } else if (item instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)item;
            if (group.operator == this.operator) {
                for (SQLExpr sqlExpr : group.getItems()) {
                    this.add(sqlExpr);
                }
                return;
            }
        }
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(index, item);
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString((SQLObject)this, this.dbType);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        boolean replaced = false;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != expr) continue;
            if (target == null) {
                this.items.remove(i);
            } else if (target instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)target).getOperator() == this.operator) {
                this.items.remove(i);
                List<SQLExpr> list = SQLBinaryOpExpr.split(target, this.operator);
                for (int j = 0; j < list.size(); ++j) {
                    SQLExpr o = list.get(j);
                    o.setParent(this);
                    this.items.add(i + j, o);
                }
            } else {
                target.setParent(this);
                this.items.set(i, target);
            }
            replaced = true;
        }
        if (this.items.size() == 1 && replaced) {
            SQLUtils.replaceInParent(this, this.items.get(0));
        }
        if (this.items.isEmpty()) {
            SQLUtils.replaceInParent(this, null);
        }
        return replaced;
    }

    public void optimize() {
        int i;
        ArrayList<Integer> dupIndexList = null;
        LinkedHashSet<SQLExpr> itemSet = new LinkedHashSet<SQLExpr>();
        for (i = 0; i < this.items.size(); ++i) {
            if (itemSet.add(this.items.get(i))) continue;
            if (dupIndexList == null) {
                dupIndexList = new ArrayList<Integer>();
            }
            dupIndexList.add(i);
        }
        if (dupIndexList != null) {
            for (i = dupIndexList.size() - 1; i >= 0; --i) {
                int index = (Integer)dupIndexList.get(i);
                this.items.remove(index);
            }
        }
    }
}

