/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink.translator;

import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.composer.definition.TransformDef;
import org.apache.flink.cdc.runtime.operators.transform.TransformDataOperator;
import org.apache.flink.cdc.runtime.operators.transform.TransformSchemaOperator;
import org.apache.flink.cdc.runtime.typeutils.EventTypeInfo;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;

public class TransformTranslator {
    public DataStream<Event> translateSchema(DataStream<Event> input, List<TransformDef> transforms) {
        if (transforms.isEmpty()) {
            return input;
        }
        TransformSchemaOperator.Builder transformSchemaFunctionBuilder = TransformSchemaOperator.newBuilder();
        for (TransformDef transform : transforms) {
            if (!transform.isValidProjection()) continue;
            transformSchemaFunctionBuilder.addTransform(transform.getSourceTable(), transform.getProjection().get(), transform.getPrimaryKeys(), transform.getPartitionKeys(), transform.getTableOptions());
        }
        return input.transform("Transform:Schema", (TypeInformation)new EventTypeInfo(), (OneInputStreamOperator)transformSchemaFunctionBuilder.build());
    }

    public DataStream<Event> translateData(DataStream<Event> input, List<TransformDef> transforms, OperatorID schemaOperatorID, String timezone) {
        if (transforms.isEmpty()) {
            return input;
        }
        TransformDataOperator.Builder transformDataFunctionBuilder = TransformDataOperator.newBuilder();
        for (TransformDef transform : transforms) {
            if (!transform.isValidProjection() && !transform.isValidFilter()) continue;
            transformDataFunctionBuilder.addTransform(transform.getSourceTable(), transform.isValidProjection() ? transform.getProjection().get() : null, transform.isValidFilter() ? transform.getFilter().get() : null);
        }
        transformDataFunctionBuilder.addSchemaOperatorID(schemaOperatorID);
        transformDataFunctionBuilder.addTimezone(timezone);
        return input.transform("Transform:Data", (TypeInformation)new EventTypeInfo(), (OneInputStreamOperator)transformDataFunctionBuilder.build());
    }
}

