/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

@Internal
public class FlinkEnvironmentUtils {
    public static void addJar(StreamExecutionEnvironment env, URL jarUrl) {
        try {
            Class<StreamExecutionEnvironment> envClass = StreamExecutionEnvironment.class;
            Field field = envClass.getDeclaredField("configuration");
            field.setAccessible(true);
            Configuration configuration = (Configuration)field.get(env);
            List jars = configuration.getOptional(PipelineOptions.JARS).orElse(new ArrayList());
            jars.add(jarUrl.toString());
            configuration.set(PipelineOptions.JARS, (Object)jars);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add JAR to Flink execution environment", e);
        }
    }
}

