/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.utils.DataTypeUtils;
import org.apache.flink.cdc.common.utils.EncodingUtils;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;

@PublicEvolving
public class DataField
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_FORMAT_WITH_DESCRIPTION = "%s %s '%s'";
    public static final String FIELD_FORMAT_NO_DESCRIPTION = "%s %s";
    private final String name;
    private final DataType type;
    @Nullable
    private final String description;

    public DataField(String name, DataType type, @Nullable String description) {
        this.name = Preconditions.checkNotNull(name, "Field name must not be null.");
        this.type = Preconditions.checkNotNull(type, "Field type must not be null.");
        this.description = description;
    }

    public DataField(String name, DataType type) {
        this(name, type, null);
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public DataField copy() {
        return new DataField(this.name, this.type.copy(), this.description);
    }

    public String asSummaryString() {
        return this.formatString(this.type.asSummaryString(), true);
    }

    public String asSerializableString() {
        return this.formatString(this.type.asSerializableString(), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataField rowField = (DataField)o;
        return this.name.equals(rowField.name) && this.type.equals(rowField.type) && Objects.equals(this.description, rowField.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description);
    }

    private String formatString(String typeString, boolean excludeDescription) {
        if (this.description == null) {
            return String.format(FIELD_FORMAT_NO_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString);
        }
        if (excludeDescription) {
            return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, "...");
        }
        return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, EncodingUtils.escapeSingleQuotes(this.description));
    }

    public DataTypes.Field toFlinkDataTypeField() {
        return this.description == null ? org.apache.flink.table.api.DataTypes.FIELD((String)this.name, (org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(this.type)) : org.apache.flink.table.api.DataTypes.FIELD((String)this.name, (org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(this.type), (String)this.description);
    }

    public static DataField fromFlinkDataTypeField(RowType.RowField rowField) {
        return DataTypes.FIELD(rowField.getName(), DataTypeUtils.fromFlinkDataType(LogicalTypeDataTypeConverter.toDataType((LogicalType)rowField.getType())), rowField.getDescription().orElse(null));
    }
}

