/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.ChangeEvent;
import org.apache.flink.cdc.common.event.OperationType;
import org.apache.flink.cdc.common.event.TableId;

@PublicEvolving
public class DataChangeEvent
implements ChangeEvent,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final RecordData before;
    private final RecordData after;
    private final OperationType op;
    private final Map<String, String> meta;

    private DataChangeEvent(TableId tableId, RecordData before, RecordData after, OperationType op, Map<String, String> meta) {
        this.tableId = tableId;
        this.before = before;
        this.after = after;
        this.op = op;
        this.meta = meta;
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    public RecordData before() {
        return this.before;
    }

    public RecordData after() {
        return this.after;
    }

    public OperationType op() {
        return this.op;
    }

    public String opTypeString(boolean isAfter) {
        switch (this.op) {
            case INSERT: {
                return "+I";
            }
            case UPDATE: {
                return isAfter ? "+U" : "-U";
            }
            case DELETE: {
                return "-D";
            }
        }
        throw new UnsupportedOperationException("Unknown operation type: " + (Object)((Object)this.op));
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public static DataChangeEvent insertEvent(TableId tableId, RecordData after) {
        return new DataChangeEvent(tableId, null, after, OperationType.INSERT, Collections.emptyMap());
    }

    public static DataChangeEvent insertEvent(TableId tableId, RecordData after, Map<String, String> meta) {
        return new DataChangeEvent(tableId, null, after, OperationType.INSERT, meta);
    }

    public static DataChangeEvent deleteEvent(TableId tableId, RecordData before) {
        return new DataChangeEvent(tableId, before, null, OperationType.DELETE, Collections.emptyMap());
    }

    public static DataChangeEvent deleteEvent(TableId tableId, RecordData before, Map<String, String> meta) {
        return new DataChangeEvent(tableId, before, null, OperationType.DELETE, meta);
    }

    public static DataChangeEvent updateEvent(TableId tableId, RecordData before, RecordData after) {
        return new DataChangeEvent(tableId, before, after, OperationType.UPDATE, Collections.emptyMap());
    }

    public static DataChangeEvent updateEvent(TableId tableId, RecordData before, RecordData after, Map<String, String> meta) {
        return new DataChangeEvent(tableId, before, after, OperationType.UPDATE, meta);
    }

    public static DataChangeEvent replaceEvent(TableId tableId, RecordData after) {
        return new DataChangeEvent(tableId, null, after, OperationType.REPLACE, Collections.emptyMap());
    }

    public static DataChangeEvent replaceEvent(TableId tableId, RecordData after, Map<String, String> meta) {
        return new DataChangeEvent(tableId, null, after, OperationType.REPLACE, meta);
    }

    public static DataChangeEvent projectBefore(DataChangeEvent dataChangeEvent, RecordData projectedBefore) {
        return new DataChangeEvent(dataChangeEvent.tableId, projectedBefore, dataChangeEvent.after, dataChangeEvent.op, dataChangeEvent.meta);
    }

    public static DataChangeEvent projectAfter(DataChangeEvent dataChangeEvent, RecordData projectedAfter) {
        return new DataChangeEvent(dataChangeEvent.tableId, dataChangeEvent.before, projectedAfter, dataChangeEvent.op, dataChangeEvent.meta);
    }

    public static DataChangeEvent projectRecords(DataChangeEvent dataChangeEvent, RecordData projectedBefore, RecordData projectedAfter) {
        return new DataChangeEvent(dataChangeEvent.tableId, projectedBefore, projectedAfter, dataChangeEvent.op, dataChangeEvent.meta);
    }

    public static DataChangeEvent route(DataChangeEvent dataChangeEvent, TableId tableId) {
        return new DataChangeEvent(tableId, dataChangeEvent.before, dataChangeEvent.after, dataChangeEvent.op, dataChangeEvent.meta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeEvent)) {
            return false;
        }
        DataChangeEvent that = (DataChangeEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.before, that.before) && Objects.equals(this.after, that.after) && this.op == that.op && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tableId, this.before, this.after, this.op, this.meta});
    }

    public String describeMeta() {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (this.meta != null && !this.meta.isEmpty()) {
            stringBuilder.append(this.meta);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toReadableString(Function<RecordData, ?> extractor) {
        return "DataChangeEvent{tableId=" + this.tableId + ", before=" + extractor.apply(this.before) + ", after=" + extractor.apply(this.after) + ", op=" + (Object)((Object)this.op) + ", meta=" + this.describeMeta() + '}';
    }

    public String toString() {
        return "DataChangeEvent{tableId=" + this.tableId + ", before=" + this.before + ", after=" + this.after + ", op=" + (Object)((Object)this.op) + ", meta=" + this.describeMeta() + '}';
    }
}

