/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.StringUtils;

@PublicEvolving
public final class RowType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "ROW<%s>";
    private final List<DataField> fields;

    public RowType(boolean isNullable, List<DataField> fields) {
        super(isNullable, DataTypeRoot.ROW);
        this.fields = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(fields, "Fields must not be null.")));
        RowType.validateFields(fields);
    }

    public RowType(List<DataField> fields) {
        this(true, fields);
    }

    public List<DataField> getFields() {
        return this.fields;
    }

    public List<String> getFieldNames() {
        return this.fields.stream().map(DataField::getName).collect(Collectors.toList());
    }

    public List<DataType> getFieldTypes() {
        return this.fields.stream().map(DataField::getType).collect(Collectors.toList());
    }

    public DataType getTypeAt(int i) {
        return this.fields.get(i).getType();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new RowType(isNullable, this.fields.stream().map(DataField::copy).collect(Collectors.toList()));
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.fields.stream().map(DataField::asSummaryString).collect(Collectors.joining(", ")));
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.fields.stream().map(DataField::asSerializableString).collect(Collectors.joining(", ")));
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.unmodifiableList(this.fields.stream().map(DataField::getType).collect(Collectors.toList()));
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType rowType = (RowType)o;
        return this.fields.equals(rowType.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    private static void validateFields(List<DataField> fields) {
        List fieldNames = fields.stream().map(DataField::getName).collect(Collectors.toList());
        if (fieldNames.stream().anyMatch(StringUtils::isNullOrWhitespaceOnly)) {
            throw new IllegalArgumentException("Field names must contain at least one non-whitespace character.");
        }
        Set duplicates = fieldNames.stream().filter(n -> Collections.frequency(fieldNames, n) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field names must be unique. Found duplicates: %s", duplicates));
        }
    }

    public static RowType of(DataType ... types) {
        return RowType.of(true, types);
    }

    public static RowType of(boolean isNullable, DataType ... types) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField("f" + i, types[i]));
        }
        return new RowType(isNullable, fields);
    }

    public static RowType of(DataType[] types, String[] names) {
        return RowType.of(true, types, names);
    }

    public static RowType of(boolean nullable, DataType[] types, String[] names) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField(names[i], types[i]));
        }
        return new RowType(nullable, fields);
    }

    public static Builder builder() {
        return RowType.builder(true);
    }

    public static Builder builder(boolean isNullable) {
        return new Builder(isNullable);
    }

    public static class Builder {
        private final List<DataField> fields = new ArrayList<DataField>();
        private final boolean isNullable;

        private Builder(boolean isNullable) {
            this.isNullable = isNullable;
        }

        public Builder field(String name, DataType type) {
            this.fields.add(new DataField(name, type));
            return this;
        }

        public Builder field(String name, DataType type, String description) {
            this.fields.add(new DataField(name, type, description));
            return this;
        }

        public Builder fields(List<DataType> types) {
            for (int i = 0; i < types.size(); ++i) {
                this.field("f" + i, types.get(i));
            }
            return this;
        }

        public Builder fields(DataType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.field("f" + i, types[i]);
            }
            return this;
        }

        public Builder fields(DataType[] types, String[] names) {
            for (int i = 0; i < types.length; ++i) {
                this.field(names[i], types[i]);
            }
            return this;
        }

        public RowType build() {
            return new RowType(this.isNullable, this.fields);
        }
    }
}

