/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.StringData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.util.CollectionUtil;

public class DataTypeUtils {
    public static Class<?> toInternalConversionClass(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return StringData.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return DecimalData.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return TimestampData.class;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return ZonedTimestampData.class;
            }
            case ARRAY: {
                return ArrayData.class;
            }
            case MAP: {
                return MapData.class;
            }
            case ROW: {
                return RecordData.class;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static org.apache.flink.table.types.DataType toFlinkDataType(DataType type) {
        List<DataType> children = type.getChildren();
        int length = DataTypes.getLength(type).orElse(0);
        int precision = DataTypes.getPrecision(type).orElse(0);
        int scale = DataTypes.getScale(type).orElse(0);
        switch (type.getTypeRoot()) {
            case CHAR: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.CHAR((int)length) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.CHAR((int)length).notNull();
            }
            case VARCHAR: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.VARCHAR((int)length) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.VARCHAR((int)length).notNull();
            }
            case BOOLEAN: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.BOOLEAN() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.BOOLEAN().notNull();
            }
            case BINARY: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.BINARY((int)length) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.BINARY((int)length).notNull();
            }
            case VARBINARY: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.VARBINARY((int)length) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.VARBINARY((int)length).notNull();
            }
            case DECIMAL: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.DECIMAL((int)precision, (int)scale) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.DECIMAL((int)precision, (int)scale).notNull();
            }
            case TINYINT: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.TINYINT() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.TINYINT().notNull();
            }
            case SMALLINT: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.SMALLINT() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.SMALLINT().notNull();
            }
            case INTEGER: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.INT() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.INT().notNull();
            }
            case DATE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.DATE() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.DATE().notNull();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.TIME((int)precision) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.TIME((int)precision).notNull();
            }
            case BIGINT: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.BIGINT() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.BIGINT().notNull();
            }
            case FLOAT: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.FLOAT() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.FLOAT().notNull();
            }
            case DOUBLE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.DOUBLE() : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.DOUBLE().notNull();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.TIMESTAMP((int)precision) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.TIMESTAMP((int)precision).notNull();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)precision) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)precision).notNull();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)precision) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)precision).notNull();
            }
            case ARRAY: {
                Preconditions.checkState(children != null && !children.isEmpty());
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.ARRAY((org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(0))) : org.apache.flink.table.api.DataTypes.ARRAY((org.apache.flink.table.types.DataType)((org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(0)).notNull()));
            }
            case MAP: {
                Preconditions.checkState(children != null && children.size() > 1);
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.MAP((org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(0)), (org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(1))) : org.apache.flink.table.api.DataTypes.MAP((org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(0)), (org.apache.flink.table.types.DataType)((org.apache.flink.table.types.DataType)DataTypeUtils.toFlinkDataType(children.get(1)).notNull()));
            }
            case ROW: {
                Preconditions.checkState(!CollectionUtil.isNullOrEmpty(children));
                RowType rowType = (RowType)type;
                List fields = rowType.getFields().stream().map(DataField::toFlinkDataTypeField).collect(Collectors.toList());
                return type.isNullable() ? org.apache.flink.table.api.DataTypes.ROW(fields) : (org.apache.flink.table.types.DataType)org.apache.flink.table.api.DataTypes.ROW(fields).notNull();
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }
}

