/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.cdc.cli.parser.YamlPipelineDefinitionParser;
import org.apache.flink.cdc.cli.utils.ConfigurationUtils;
import org.apache.flink.cdc.cli.utils.FlinkEnvironmentUtils;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.composer.PipelineComposer;
import org.apache.flink.cdc.composer.PipelineDeploymentExecutor;
import org.apache.flink.cdc.composer.PipelineExecution;
import org.apache.flink.cdc.composer.definition.PipelineDef;
import org.apache.flink.cdc.composer.flink.deployment.ComposeDeploymentFactory;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class CliExecutor {
    private final Path pipelineDefPath;
    private final Configuration flinkConfig;
    private final Configuration globalPipelineConfig;
    private final boolean useMiniCluster;
    private final List<Path> additionalJars;
    private final CommandLine commandLine;
    private PipelineComposer composer = null;
    private final SavepointRestoreSettings savepointSettings;

    public CliExecutor(CommandLine commandLine, Path pipelineDefPath, Configuration flinkConfig, Configuration globalPipelineConfig, boolean useMiniCluster, List<Path> additionalJars, SavepointRestoreSettings savepointSettings) {
        this.commandLine = commandLine;
        this.pipelineDefPath = pipelineDefPath;
        this.flinkConfig = flinkConfig;
        this.globalPipelineConfig = globalPipelineConfig;
        this.useMiniCluster = useMiniCluster;
        this.additionalJars = additionalJars;
        this.savepointSettings = savepointSettings;
    }

    public PipelineExecution.ExecutionInfo run() throws Exception {
        boolean isDeploymentMode = ConfigurationUtils.isDeploymentMode(this.commandLine);
        if (isDeploymentMode) {
            ComposeDeploymentFactory composeDeploymentFactory = new ComposeDeploymentFactory();
            PipelineDeploymentExecutor composeExecutor = composeDeploymentFactory.getFlinkComposeExecutor(this.commandLine);
            return composeExecutor.deploy(this.commandLine, org.apache.flink.configuration.Configuration.fromMap((Map)this.flinkConfig.toMap()), this.additionalJars);
        }
        YamlPipelineDefinitionParser pipelineDefinitionParser = new YamlPipelineDefinitionParser();
        PipelineDef pipelineDef = pipelineDefinitionParser.parse(this.pipelineDefPath, this.globalPipelineConfig);
        PipelineComposer composer = this.getComposer();
        PipelineExecution execution = composer.compose(pipelineDef);
        return execution.execute();
    }

    private PipelineComposer getComposer() throws Exception {
        if (this.composer == null) {
            return FlinkEnvironmentUtils.createComposer(this.useMiniCluster, this.flinkConfig, this.additionalJars, this.savepointSettings);
        }
        return this.composer;
    }

    @VisibleForTesting
    void setComposer(PipelineComposer composer) {
        this.composer = composer;
    }

    @VisibleForTesting
    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    @VisibleForTesting
    public Configuration getGlobalPipelineConfig() {
        return this.globalPipelineConfig;
    }

    @VisibleForTesting
    public List<Path> getAdditionalJars() {
        return this.additionalJars;
    }

    @VisibleForTesting
    public String getDeploymentTarget() {
        return this.commandLine.getOptionValue("target");
    }

    public SavepointRestoreSettings getSavepointSettings() {
        return this.savepointSettings;
    }
}

