/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli.utils;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.cli.utils.ConfigurationUtils;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.composer.flink.FlinkPipelineComposer;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkEnvironmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkEnvironmentUtils.class);
    private static final String FLINK_CONF_DIR = "conf";
    private static final String LEGACY_FLINK_CONF_FILENAME = "flink-conf.yaml";
    private static final String FLINK_CONF_FILENAME = "config.yaml";

    public static Configuration loadFlinkConfiguration(Path flinkHome) throws Exception {
        Path flinkConfPath = flinkHome.resolve(FLINK_CONF_DIR).resolve(FLINK_CONF_FILENAME);
        try {
            return ConfigurationUtils.loadConfigFile(flinkConfPath);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Failed to load the configuration file from {}. Trying to use legacy YAML parser to load flink configuration file from {}.", (Object)FLINK_CONF_FILENAME, (Object)LEGACY_FLINK_CONF_FILENAME);
            return ConfigurationUtils.loadConfigFile(flinkHome.resolve(FLINK_CONF_DIR).resolve(LEGACY_FLINK_CONF_FILENAME), true);
        }
    }

    public static FlinkPipelineComposer createComposer(boolean useMiniCluster, Configuration flinkConfig, List<Path> additionalJars, SavepointRestoreSettings savepointSettings) {
        if (useMiniCluster) {
            return FlinkPipelineComposer.ofMiniCluster();
        }
        org.apache.flink.configuration.Configuration configuration = org.apache.flink.configuration.Configuration.fromMap((Map)flinkConfig.toMap());
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)savepointSettings, (org.apache.flink.configuration.Configuration)configuration);
        return FlinkPipelineComposer.ofRemoteCluster((org.apache.flink.configuration.Configuration)configuration, additionalJars);
    }
}

