/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import java.util.Arrays;
import org.apache.flink.architecture.common.Conditions;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.JavaFieldPredicates;
import org.apache.flink.architecture.common.Predicates;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ITCaseRules {
    private static final String ABSTRACT_TEST_BASE_FQ = "org.apache.flink.test.util.AbstractTestBase";
    private static final String INTERNAL_MINI_CLUSTER_EXTENSION_FQ_NAME = "org.apache.flink.runtime.testutils.InternalMiniClusterExtension";
    private static final String MINI_CLUSTER_EXTENSION_FQ_NAME = "org.apache.flink.test.junit5.MiniClusterExtension";
    private static final String MINI_CLUSTER_TEST_ENVIRONMENT_FQ_NAME = "org.apache.flink.connector.testframe.environment.MiniClusterTestEnvironment";
    private static final String TEST_ENV_FQ_NAME = "org.apache.flink.connector.testframe.junit.annotations.TestEnv";
    @ArchTest
    public static final ArchRule INTEGRATION_TEST_ENDING_WITH_ITCASE = (ArchRule)FreezingArchRule.freeze((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().areAssignableTo(DescribedPredicate.describe((String)"is assignable to org.apache.flink.test.util.AbstractTestBase", javaClass -> javaClass.getName().equals(ABSTRACT_TEST_BASE_FQ)))).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().haveSimpleNameEndingWith("ITCase")).allowEmptyShould(true).as("Tests inheriting from AbstractTestBase should have name ending with ITCase");
    @ArchTest
    public static final ArchRule ITCASE_USE_MINICLUSTER = (ArchRule)FreezingArchRule.freeze((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().haveSimpleNameEndingWith("ITCase")).and().areTopLevelClasses()).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should(Conditions.fulfill((DescribedPredicate)ITCaseRules.miniClusterExtensionRule().or(ITCaseRules.miniClusterWithClientResourceClassRule()).or(ITCaseRules.miniClusterWithClientResourceRule())))).allowEmptyShould(true).as("ITCASE tests should use a MiniCluster resource or extension");

    private static DescribedPredicate<JavaClass> miniClusterWithClientResourceClassRule() {
        return Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.arePublicStaticFinalOfTypeWithAnnotation((String)"org.apache.flink.test.util.MiniClusterWithClientResource", ClassRule.class));
    }

    private static DescribedPredicate<JavaClass> miniClusterWithClientResourceRule() {
        return Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.arePublicFinalOfTypeWithAnnotation((String)"org.apache.flink.test.util.MiniClusterWithClientResource", Rule.class));
    }

    private static DescribedPredicate<JavaClass> inFlinkRuntimePackages() {
        return JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.runtime.*");
    }

    private static DescribedPredicate<JavaClass> outsideFlinkRuntimePackages() {
        return JavaClass.Predicates.resideOutsideOfPackage((String)"org.apache.flink.runtime.*");
    }

    private static DescribedPredicate<JavaClass> miniClusterExtensionRule() {
        return Predicates.exactlyOneOf((DescribedPredicate[])new DescribedPredicate[]{ITCaseRules.inFlinkRuntimePackages().and(Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.areStaticFinalOfTypeWithAnnotation((String)INTERNAL_MINI_CLUSTER_EXTENSION_FQ_NAME, RegisterExtension.class))), ITCaseRules.outsideFlinkRuntimePackages().and(Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.areStaticFinalOfTypeWithAnnotation((String)MINI_CLUSTER_EXTENSION_FQ_NAME, RegisterExtension.class).or(Predicates.areFieldOfType((String)MINI_CLUSTER_TEST_ENVIRONMENT_FQ_NAME, (JavaModifier[])new JavaModifier[0]).and(JavaFieldPredicates.annotatedWith((String)TEST_ENV_FQ_NAME))))), ITCaseRules.inFlinkRuntimePackages().and(ITCaseRules.isAnnotatedWithExtendWithUsingExtension(INTERNAL_MINI_CLUSTER_EXTENSION_FQ_NAME)), ITCaseRules.outsideFlinkRuntimePackages().and(ITCaseRules.isAnnotatedWithExtendWithUsingExtension(MINI_CLUSTER_EXTENSION_FQ_NAME))});
    }

    private static DescribedPredicate<JavaClass> isAnnotatedWithExtendWithUsingExtension(String extensionClassFqName) {
        return DescribedPredicate.describe((String)("is annotated with @ExtendWith with class " + Predicates.getClassSimpleNameFromFqName((String)extensionClassFqName)), clazz -> clazz.isAnnotatedWith(ExtendWith.class) && Arrays.stream(((ExtendWith)clazz.getAnnotationOfType(ExtendWith.class)).value()).map(Class::getCanonicalName).anyMatch(s -> s.equals(extensionClassFqName)));
    }
}

