/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.CheckpointConfig;

public class CheckpointingConfigurationAccessRules {
    private static final String CHECKPOINTING_OPTIONS_CLASS = CheckpointingOptions.class.getName();
    private static final Set<String> PROHIBITED_CONFIG_FIELDS = CheckpointingConfigurationAccessRules.getProhibitedFieldNames();
    private static final Map<String, Set<String>> ALLOWED_CLASSES_AND_METHODS = CheckpointingConfigurationAccessRules.buildAllowedAccessMap();
    @ArchTest
    public static final ArchRule SHOULD_NOT_DIRECTLY_ACCESS_PROHIBITED_CONFIG_OPTIONS = ArchRuleDefinition.noClasses().should().callMethodWhere((DescribedPredicate)new DescribedPredicate<JavaMethodCall>("Configuration.get() or Configuration.getOptional() calls with prohibited CheckpointingOptions", new Object[0]){

        public boolean test(JavaMethodCall call) {
            Set<String> allowedMethods;
            if (!((AccessTarget.MethodCallTarget)call.getTarget()).getName().equals("get") && !((AccessTarget.MethodCallTarget)call.getTarget()).getName().equals("getOptional") || !call.getTargetOwner().isAssignableTo(Configuration.class)) {
                return false;
            }
            if (call.getOriginOwner().getName().equals(CHECKPOINTING_OPTIONS_CLASS)) {
                return false;
            }
            String originClassName = call.getOriginOwner().getName();
            String originMethodName = call.getOrigin().getName();
            if (ALLOWED_CLASSES_AND_METHODS.containsKey(originClassName) && (allowedMethods = ALLOWED_CLASSES_AND_METHODS.get(originClassName)).contains(originMethodName)) {
                return false;
            }
            boolean hasProhibitedFieldAccess = call.getOrigin().getFieldAccesses().stream().anyMatch(x$0 -> CheckpointingConfigurationAccessRules.isProhibitedConfigFieldAccess(x$0));
            return hasProhibitedFieldAccess;
        }
    }).allowEmptyShould(true).because("Direct use of certain CheckpointingOptions configuration fields with Configuration.get() or Configuration.getOptional() should be avoided. \nUse the appropriate helper methods which include proper validation logic:\n- ENABLE_UNALIGNED: Use CheckpointingOptions.isUnalignedCheckpointEnabled(Configuration)\n- CHECKPOINTING_CONSISTENCY_MODE: Use CheckpointingOptions.getCheckpointingMode(Configuration)\n- ENABLE_UNALIGNED_INTERRUPTIBLE_TIMERS: Use CheckpointingOptions.isUnalignedCheckpointInterruptibleTimersEnabled(Configuration)");

    private static Set<String> getProhibitedFieldNames() {
        try {
            return new HashSet<String>(Arrays.asList(CheckpointingOptions.class.getField("ENABLE_UNALIGNED").getName(), CheckpointingOptions.class.getField("CHECKPOINTING_CONSISTENCY_MODE").getName(), CheckpointingOptions.class.getField("ENABLE_UNALIGNED_INTERRUPTIBLE_TIMERS").getName()));
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static Map<String, Set<String>> buildAllowedAccessMap() {
        try {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            HashSet<String> checkpointingOptionsMethods = new HashSet<String>(List.of(CheckpointingOptions.class.getMethod("isUnalignedCheckpointEnabled", Configuration.class).getName(), CheckpointingOptions.class.getMethod("isCheckpointingEnabled", Configuration.class).getName(), CheckpointingOptions.class.getMethod("getCheckpointingMode", Configuration.class).getName(), CheckpointingOptions.class.getMethod("isUnalignedCheckpointInterruptibleTimersEnabled", Configuration.class).getName()));
            map.put(CheckpointingOptions.class.getName(), checkpointingOptionsMethods);
            HashSet<String> checkpointConfigMethods = new HashSet<String>(List.of(CheckpointConfig.class.getMethod("configure", ReadableConfig.class).getName()));
            map.put(CheckpointConfig.class.getName(), checkpointConfigMethods);
            return map;
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static boolean isProhibitedConfigFieldAccess(JavaFieldAccess fieldAccess) {
        return PROHIBITED_CONFIG_FIELDS.contains(((AccessTarget.FieldAccessTarget)fieldAccess.getTarget()).getName()) && fieldAccess.getTargetOwner().getName().equals(CHECKPOINTING_OPTIONS_CLASS);
    }
}

