/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URL;
import org.apache.felix.webconsole.User;
import org.apache.felix.webconsole.spi.SecurityProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

final class OsgiManagerHttpContext
extends ServletContextHelper {
    private final ServiceTracker<SecurityProvider, SecurityProvider> tracker;
    private final Bundle bundle;

    OsgiManagerHttpContext(Bundle webConsoleBundle, ServiceTracker<SecurityProvider, SecurityProvider> tracker) {
        super(webConsoleBundle);
        this.tracker = tracker;
        this.bundle = webConsoleBundle;
    }

    public URL getResource(String name) {
        URL url = this.bundle.getResource(name);
        if (url == null && name.endsWith("/")) {
            url = this.bundle.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(final HttpServletRequest r, HttpServletResponse response) {
        Object result;
        final SecurityProvider provider = (SecurityProvider)this.tracker.getService();
        HttpServletRequestWrapper request = new HttpServletRequestWrapper(r){

            public String getContextPath() {
                return "";
            }

            public String getServletPath() {
                return r.getContextPath();
            }

            public String getPathInfo() {
                return r.getServletPath();
            }
        };
        Object object = result = provider == null ? null : provider.authenticate((HttpServletRequest)request, response);
        if (result != null) {
            request.setAttribute(org.apache.felix.webconsole.servlet.User.USER_ATTRIBUTE, (Object)new User(){

                @Override
                public boolean authorize(String role) {
                    Object user = this.getUserObject();
                    if (user == null) {
                        return false;
                    }
                    if (provider == null) {
                        return true;
                    }
                    return provider.authorize(user, role);
                }

                @Override
                public Object getUserObject() {
                    return result;
                }
            });
            request.setAttribute(User.USER_ATTRIBUTE, request.getAttribute(org.apache.felix.webconsole.servlet.User.USER_ATTRIBUTE));
        }
        return result != null;
    }
}

