/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.configuration.MetatypePropertyDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

class MetaTypeServiceSupport
extends MetaTypeSupport {
    private final BundleContext bundleContext;
    private final MetaTypeService service;
    private static final IdGetter PID_GETTER = new IdGetter(){

        @Override
        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getPids();
        }
    };
    private static final IdGetter FACTORY_PID_GETTER = new IdGetter(){

        @Override
        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getFactoryPids();
        }
    };

    MetaTypeServiceSupport(BundleContext bundleContext, Object service) {
        this.bundleContext = bundleContext;
        this.service = (MetaTypeService)service;
    }

    Map<String, ObjectClassDefinition> getPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(PID_GETTER, locale);
    }

    Map<String, ObjectClassDefinition> getFactoryPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(FACTORY_PID_GETTER, locale);
    }

    private Map<String, ObjectClassDefinition> getObjectClassDefinitions(IdGetter idGetter, String locale) {
        HashMap<String, ObjectClassDefinition> objectClassesDefinitions = new HashMap<String, ObjectClassDefinition>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            MetaTypeInformation mti = this.service.getMetaTypeInformation(bundle);
            if (mti == null) continue;
            String[] idList = idGetter.getIds(mti);
            for (int j = 0; idList != null && j < idList.length; ++j) {
                ObjectClassDefinition ocd = null;
                try {
                    ocd = mti.getObjectClassDefinition(idList[j], locale);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (ocd == null) continue;
                objectClassesDefinitions.put(idList[j], ocd);
            }
        }
        return objectClassesDefinitions;
    }

    ObjectClassDefinition getObjectClassDefinition(Configuration config, String locale) {
        Bundle bundle;
        if (config.getBundleLocation() != null && (bundle = MetaTypeServiceSupport.getBundle(this.bundleContext, config.getBundleLocation())) != null) {
            String id = config.getFactoryPid();
            if (null == id) {
                id = config.getPid();
            }
            return this.getObjectClassDefinition(bundle, id, locale);
        }
        if (config.getFactoryPid() != null) {
            return this.getObjectClassDefinition(config.getFactoryPid(), locale);
        }
        return this.getObjectClassDefinition(config.getPid(), locale);
    }

    ObjectClassDefinition getObjectClassDefinition(Bundle bundle, String pid, String locale) {
        MetaTypeInformation mti;
        if (bundle != null && (mti = this.service.getMetaTypeInformation(bundle)) != null) {
            try {
                return mti.getObjectClassDefinition(pid, locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            ObjectClassDefinition ocd = this.getObjectClassDefinition(bundle, pid, locale);
            if (ocd == null) continue;
            return ocd;
        }
        return null;
    }

    Map<String, MetatypePropertyDescriptor> getAttributeDefinitionMap(Configuration config, String locale) {
        AttributeDefinition[] ad;
        HashMap<String, MetatypePropertyDescriptor> adMap = new HashMap<String, MetatypePropertyDescriptor>();
        ObjectClassDefinition ocd = this.getObjectClassDefinition(config, locale);
        if (ocd != null && (ad = ocd.getAttributeDefinitions(-1)) != null) {
            for (int i = 0; i < ad.length; ++i) {
                adMap.put(ad[i].getID(), new MetatypePropertyDescriptor(ad[i], false));
            }
        }
        return adMap;
    }

    private static interface IdGetter {
        public String[] getIds(MetaTypeInformation var1);
    }
}

