/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Closeable;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper;
import org.apache.felix.http.jakartawrappers.ServletWrapper;
import org.apache.felix.webconsole.WebConsoleSecurityProvider3;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.JakartaServletAdapter;
import org.apache.felix.webconsole.internal.servlet.Plugin;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.apache.felix.webconsole.spi.SecurityProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JakartaServiceTracker
implements Closeable,
ServiceTrackerCustomizer<jakarta.servlet.Servlet, JakartaServletPlugin> {
    private final ServiceTracker<jakarta.servlet.Servlet, JakartaServletPlugin> servletTracker;
    private final PluginHolder pluginHolder;
    private final JakartaSecurityProviderTracker securityProviderTracker;

    public JakartaServiceTracker(PluginHolder pluginHolder, BundleContext context) {
        new ServletWrapper(null);
        this.pluginHolder = pluginHolder;
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=" + jakarta.servlet.Servlet.class.getName() + ")(" + "felix.webconsole.label" + "=*))");
        }
        catch (InvalidSyntaxException e) {
            throw new InternalError("Failed creating filter: " + e.getMessage());
        }
        this.servletTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)this);
        this.servletTracker.open();
        this.securityProviderTracker = new JakartaSecurityProviderTracker(context);
    }

    @Override
    public void close() {
        this.servletTracker.close();
        this.securityProviderTracker.close();
    }

    public JakartaServletPlugin addingService(ServiceReference<jakarta.servlet.Servlet> reference) {
        String label = Util.getStringProperty(reference, "felix.webconsole.label");
        if (label != null) {
            JakartaServletPlugin plugin = new JakartaServletPlugin(this.pluginHolder, reference, label);
            this.pluginHolder.addPlugin(plugin);
            return plugin;
        }
        return null;
    }

    public void modifiedService(ServiceReference<jakarta.servlet.Servlet> reference, JakartaServletPlugin service) {
        this.removedService(reference, service);
        this.addingService((ServiceReference)reference);
    }

    public void removedService(ServiceReference<jakarta.servlet.Servlet> reference, JakartaServletPlugin service) {
        this.pluginHolder.removePlugin(service);
    }

    public static class JakartaSecurityProvider
    implements WebConsoleSecurityProvider3 {
        private final SecurityProvider provider;

        public JakartaSecurityProvider(SecurityProvider provider) {
            this.provider = provider;
        }

        @Override
        public void logout(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
            this.provider.logout((HttpServletRequest)HttpServletRequestWrapper.getWrapper((ServletRequest)request), (jakarta.servlet.http.HttpServletResponse)HttpServletResponseWrapper.getWrapper((ServletResponse)response));
        }

        @Override
        public boolean authenticate(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
            Object user = this.provider.authenticate((HttpServletRequest)HttpServletRequestWrapper.getWrapper((ServletRequest)request), (jakarta.servlet.http.HttpServletResponse)HttpServletResponseWrapper.getWrapper((ServletResponse)response));
            if (user != null) {
                request.setAttribute("org.apache.felix.webconsole.user", user);
            }
            return user != null;
        }

        @Override
        public Object authenticate(String username, String password) {
            return null;
        }

        @Override
        public boolean authorize(Object user, String role) {
            return this.provider.authorize(user, role);
        }
    }

    public static class JakartaSecurityProviderTracker
    implements ServiceTrackerCustomizer<SecurityProvider, ServiceRegistration<WebConsoleSecurityProvider3>> {
        private final ServiceTracker<SecurityProvider, ServiceRegistration<WebConsoleSecurityProvider3>> tracker;
        private final BundleContext bundleContext;

        public JakartaSecurityProviderTracker(BundleContext context) {
            this.bundleContext = context;
            this.tracker = new ServiceTracker(context, SecurityProvider.class, (ServiceTrackerCustomizer)this);
            this.tracker.open();
        }

        public void close() {
            this.tracker.close();
        }

        public ServiceRegistration<WebConsoleSecurityProvider3> addingService(ServiceReference<SecurityProvider> reference) {
            SecurityProvider provider = (SecurityProvider)this.bundleContext.getService(reference);
            if (provider != null) {
                JakartaSecurityProvider jakartaSecurityProvider = new JakartaSecurityProvider(provider);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                if (reference.getProperty("service.ranking") != null) {
                    ((Dictionary)props).put("service.ranking", reference.getProperty("service.ranking"));
                }
                ServiceRegistration reg = this.bundleContext.registerService(WebConsoleSecurityProvider3.class, (Object)jakartaSecurityProvider, props);
                return reg;
            }
            return null;
        }

        public void modifiedService(ServiceReference<SecurityProvider> reference, ServiceRegistration<WebConsoleSecurityProvider3> service) {
        }

        public void removedService(ServiceReference<SecurityProvider> reference, ServiceRegistration<WebConsoleSecurityProvider3> service) {
            this.bundleContext.ungetService(reference);
            try {
                service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static class JakartaServletPlugin
    extends Plugin.ServletPlugin {
        public JakartaServletPlugin(PluginHolder holder, ServiceReference<jakarta.servlet.Servlet> serviceReference, String label) {
            super(holder, serviceReference, label);
        }

        @Override
        protected Servlet getService() {
            final jakarta.servlet.Servlet servlet = (jakarta.servlet.Servlet)this.getHolder().getBundleContext().getService(this.getServiceReference());
            if (servlet != null) {
                if (servlet instanceof AbstractServlet) {
                    return new JakartaServletAdapter((AbstractServlet)servlet, this.getServiceReference());
                }
                final String prefix = "/".concat(this.getLabel());
                final String resStart = prefix.concat("/res/");
                return new org.apache.felix.http.javaxwrappers.ServletWrapper(servlet){

                    public URL getResource(String path) {
                        if (path != null && path.startsWith(resStart)) {
                            return servlet.getClass().getResource(path.substring(prefix.length()));
                        }
                        return null;
                    }
                };
            }
            return null;
        }
    }
}

