/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.misc.ConfigurationPrinterAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationRender
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "config";
    private static final String TITLE = "%configStatus.pluginTitle";
    private static final String[] CSS_REFS = new String[]{"/res/ui/configurationrender.css"};
    private static final Locale DEFAULT = Locale.ENGLISH;
    private static final DateFormat DISPLAY_DATE_FORMAT = DateFormat.getDateTimeInstance(1, 1, Locale.US);
    private final ResourceBundleManager resourceBundleManager;
    private ServiceTracker cfgPrinterTracker;
    private int cfgPrinterTrackerCount;
    private ArrayList configurationPrinters;
    static /* synthetic */ Class class$org$apache$felix$webconsole$ConfigurationPrinter;

    public ConfigurationRender(ResourceBundleManager resourceBundleManager) {
        super(LABEL, TITLE, CSS_REFS);
        this.resourceBundleManager = resourceBundleManager;
    }

    public void deactivate() {
        ServiceTracker oldTracker = this.cfgPrinterTracker;
        if (oldTracker != null) {
            oldTracker.close();
        }
        this.cfgPrinterTracker = null;
        this.configurationPrinters = null;
        super.deactivate();
    }

    private String getRequestedPrinterName(HttpServletRequest request) {
        String name = request.getPathInfo();
        int dotPos = name.lastIndexOf(46);
        if (dotPos != -1) {
            name = name.substring(0, dotPos);
        }
        name = name.substring(name.lastIndexOf(47) + 1);
        name = WebConsoleUtil.urlDecode(name);
        return name;
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo().endsWith(".txt")) {
            response.setContentType("text/plain; charset=utf-8");
            PlainTextConfigurationWriter pw = new PlainTextConfigurationWriter(response.getWriter());
            this.printConfigurationStatus(pw, "txt", this.getRequestedPrinterName(request));
            pw.flush();
        } else if (request.getPathInfo().endsWith(".zip")) {
            String type = this.getServletContext().getMimeType(request.getPathInfo());
            if (type == null) {
                type = "application/x-zip";
            }
            response.setContentType(type);
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            zip.setLevel(1);
            zip.setMethod(8);
            ZipConfigurationWriter pw = new ZipConfigurationWriter(zip);
            this.printConfigurationStatus(pw, "zip", this.getRequestedPrinterName(request));
            pw.flush();
            this.addAttachments(pw, "zip");
            zip.finish();
        } else if (request.getPathInfo().endsWith(".nfo")) {
            Iterator i;
            WebConsoleUtil.setNoCache(response);
            response.setContentType("text/html; charset=utf-8");
            String name = this.getRequestedPrinterName(request);
            HtmlConfigurationWriter pw = new HtmlConfigurationWriter(response.getWriter());
            pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            pw.println("  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            pw.println("<head><title>dummy</title></head><body><div>");
            List printers = this.getPrintersForLabel(name);
            if (printers != null && (i = printers.iterator()).hasNext()) {
                ConfigurationPrinterAdapter desc = (ConfigurationPrinterAdapter)i.next();
                pw.enableFilter(desc.escapeHtml());
                this.printConfigurationPrinter(pw, desc, "web");
                pw.enableFilter(false);
                pw.println("</div></body></html>");
                return;
            }
            response.sendError(500, "Invalid configuration printer: " + name);
        } else {
            super.doGet(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.println("<script type='text/javascript' src='${appRoot}/res/ui/ui.tabs.paging.js'></script>");
        pw.println("<script type='text/javascript' src='${appRoot}/res/ui/configurationrender.js'></script>");
        pw.println("<br/><p class=\"statline\">");
        Date currentTime = new Date();
        DateFormat dateFormat = DISPLAY_DATE_FORMAT;
        synchronized (dateFormat) {
            pw.print("Date: ");
            pw.println(DISPLAY_DATE_FORMAT.format(currentTime));
        }
        pw.print("<button type=\"button\" class=\"downloadZip\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download Zip</button>");
        pw.print("<button type=\"button\" class=\"downloadTxt\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download Text</button>");
        pw.println("<br/>&nbsp;</p>");
        pw.println("<div id='tabs'> <!-- tabs container -->");
        pw.println("<ul> <!-- tabs on top -->");
        String pluginRoot = request.getAttribute("felix.webconsole.pluginRoot") + "/";
        List printers = this.getConfigurationPrinters();
        Iterator i = printers.iterator();
        while (i.hasNext()) {
            ConfigurationPrinterAdapter desc = (ConfigurationPrinterAdapter)i.next();
            if (!desc.match("web")) continue;
            String label = desc.label;
            String title = desc.title;
            pw.print("<li><a href='" + pluginRoot + URLEncoder.encode(label) + ".nfo'>" + title + "</a></li>");
        }
        pw.println("</ul> <!-- end tabs on top -->");
        pw.println();
        pw.println("</div> <!-- end tabs container -->");
        pw.println("<div id=\"waitDlg\" title=\"${configStatus.wait}\" class=\"ui-helper-hidden\"><img src=\"${appRoot}/res/imgs/loading.gif\" alt=\"${configStatus.wait}\" />${configStatus.wait.msg}</div>");
        pw.flush();
    }

    private List getPrintersForLabel(String label) {
        ArrayList<ConfigurationPrinterAdapter> list = null;
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            ConfigurationPrinterAdapter desc = (ConfigurationPrinterAdapter)cpi.next();
            if (!desc.label.equals(label) || list != null) continue;
            list = new ArrayList<ConfigurationPrinterAdapter>();
            list.add(desc);
        }
        return list;
    }

    private void printConfigurationStatus(ConfigurationWriter pw, String mode, String optionalLabel) {
        List printers = this.getPrintersForLabel(optionalLabel);
        if (printers == null) {
            printers = this.getConfigurationPrinters();
        }
        Iterator cpi = printers.iterator();
        while (cpi.hasNext()) {
            ConfigurationPrinterAdapter desc = (ConfigurationPrinterAdapter)cpi.next();
            if (!desc.match(mode)) continue;
            this.printConfigurationPrinter(pw, desc, mode);
        }
    }

    private final synchronized List getConfigurationPrinters() {
        if (this.cfgPrinterTracker == null) {
            try {
                this.cfgPrinterTracker = new ServiceTracker(this.getBundleContext(), this.getBundleContext().createFilter("(|(objectClass=" + (class$org$apache$felix$webconsole$ConfigurationPrinter == null ? (class$org$apache$felix$webconsole$ConfigurationPrinter = ConfigurationRender.class$("org.apache.felix.webconsole.ConfigurationPrinter")) : class$org$apache$felix$webconsole$ConfigurationPrinter).getName() + ")" + "(&(" + "felix.webconsole.label" + "=*)(&(" + "felix.webconsole.title" + "=*)(" + "felix.webconsole.configprinter.modes" + "=*))))"), null);
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            this.cfgPrinterTracker.open();
            this.cfgPrinterTrackerCount = -1;
        }
        if (this.cfgPrinterTrackerCount != this.cfgPrinterTracker.getTrackingCount()) {
            TreeMap cp = new TreeMap();
            ServiceReference[] refs = this.cfgPrinterTracker.getServiceReferences();
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    ConfigurationPrinterAdapter desc;
                    ServiceReference ref = refs[i];
                    Object service = this.cfgPrinterTracker.getService(ref);
                    if (service == null || (desc = ConfigurationPrinterAdapter.createAdapter(service, ref)) == null) continue;
                    this.addConfigurationPrinter(cp, desc, ref.getBundle());
                }
            }
            this.configurationPrinters = new ArrayList(cp.values());
            this.cfgPrinterTrackerCount = this.cfgPrinterTracker.getTrackingCount();
        }
        return this.configurationPrinters;
    }

    private final void addConfigurationPrinter(SortedMap printers, ConfigurationPrinterAdapter desc, Bundle provider) {
        desc.title = this.getTitle(desc.title, provider);
        String sortKey = desc.title;
        if (printers.containsKey(sortKey)) {
            String idxTitle;
            int idx = -1;
            while (printers.containsKey(idxTitle = sortKey + ++idx)) {
            }
            sortKey = idxTitle;
        }
        if (desc.label == null) {
            desc.label = sortKey;
        }
        printers.put(sortKey, desc);
    }

    private final void printConfigurationPrinter(ConfigurationWriter pw, ConfigurationPrinterAdapter desc, String mode) {
        pw.title(desc.title);
        try {
            desc.printConfiguration(pw, mode);
        }
        catch (Throwable t) {
            pw.println();
            pw.println("Configuration Printer failed: " + t.toString());
            pw.println();
            this.log("Configuration Printer " + desc + " failed", t);
        }
        pw.end();
    }

    public static final void infoLine(PrintWriter pw, String indent, String label, Object value) {
        if (indent != null) {
            pw.print(indent);
        }
        if (label != null) {
            pw.print(label);
            pw.print(" = ");
        }
        pw.print(WebConsoleUtil.toString(value));
        pw.println();
    }

    private final String getTitle(String title, Bundle provider) {
        if (!title.startsWith("%")) {
            return title;
        }
        ResourceBundle res = this.resourceBundleManager.getResourceBundle(provider, DEFAULT);
        return res.getString(title.substring(1));
    }

    private void addAttachments(ConfigurationWriter cf, String mode) throws IOException {
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            URL[] attachments;
            ConfigurationPrinterAdapter desc = (ConfigurationPrinterAdapter)cpi.next();
            if (!desc.match(mode) || (attachments = desc.getAttachments(mode)) == null) continue;
            cf.handleAttachments(desc.title, attachments);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ZipConfigurationWriter
    extends ConfigurationWriter {
        private final ZipOutputStream zip;
        private int counter;

        ZipConfigurationWriter(ZipOutputStream zip) {
            super(new OutputStreamWriter(zip));
            this.zip = zip;
        }

        public void title(String title) {
            String name = MessageFormat.format("{0,number,000}-{1}.txt", new Integer(this.counter), title);
            ++this.counter;
            ZipEntry entry = new ZipEntry(name);
            try {
                this.zip.putNextEntry(entry);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        private OutputStream startFile(String title, String name) {
            String path = MessageFormat.format("{0,number,000}-{1}/{2}", new Integer(this.counter), title, name);
            ZipEntry entry = new ZipEntry(path);
            try {
                this.zip.putNextEntry(entry);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.zip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAttachments(String title, URL[] attachments) throws IOException {
            for (int i = 0; i < attachments.length; ++i) {
                int pos;
                URL current = attachments[i];
                String path = current.getPath();
                String name = path == null || path.length() == 0 ? "file" + Double.doubleToLongBits(Math.random()) : ((pos = path.lastIndexOf(47)) == -1 ? path : path.substring(pos + 1));
                OutputStream os = this.startFile(title, name);
                InputStream is = current.openStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
                this.end();
            }
            ++this.counter;
        }

        public void end() {
            this.flush();
            try {
                this.zip.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class PlainTextConfigurationWriter
    extends ConfigurationWriter {
        PlainTextConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        public void title(String title) {
            this.print("*** ");
            this.print(title);
            this.println(":");
        }

        public void end() {
            this.println();
        }
    }

    private static class HtmlConfigurationWriter
    extends ConfigurationWriter {
        private boolean doFilter;
        private final char[] oneChar = new char[1];

        HtmlConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        void enableFilter(boolean doFilter) {
            this.doFilter = doFilter;
        }

        public void title(String title) {
        }

        public void end() {
        }

        public void println() {
            if (this.doFilter) {
                this.write(10);
            } else {
                super.println();
            }
        }

        public void print(String str) {
            char[] chars = str.toCharArray();
            this.write(chars, 0, chars.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int character) {
            char[] cArray = this.oneChar;
            synchronized (this.oneChar) {
                this.oneChar[0] = (char)character;
                this.write(this.oneChar, 0, 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void write(char[] chars, int off, int len) {
            if (this.doFilter) {
                chars = WebConsoleUtil.escapeHtml(new String(chars, off, len)).toCharArray();
                off = 0;
                len = chars.length;
            }
            super.write(chars, off, len);
        }

        public void write(String string, int off, int len) {
            this.write(string.toCharArray(), off, len);
        }
    }

    private static abstract class ConfigurationWriter
    extends PrintWriter {
        ConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        abstract void title(String var1);

        abstract void end();

        public void handleAttachments(String title, URL[] urls) throws IOException {
            throw new UnsupportedOperationException("handleAttachments not supported by this configuration writer: " + this);
        }
    }
}

