/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultBrandingPlugin;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.VariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    public static final String GET_RESOURCE_METHOD_NAME = "getResource";
    private static String HEADER;
    private static String FOOTER;
    private Method getResourceMethod;
    private boolean getResourceMethodChecked;
    private BundleContext bundleContext;
    private static BrandingPlugin brandingPlugin;
    private static int logLevel;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$apache$felix$webconsole$AbstractWebConsolePlugin;

    public String getServletName() {
        return this.getTitle();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.spoolResource(request, response)) {
            if (this.isHtmlRequest(request)) {
                PrintWriter pw = this.startResponse(request, response);
                this.renderTopNavigation(request, pw);
                pw.println("<div id='content'>");
                this.renderContent(request, response);
                pw.println("</div>");
                this.endResponse(pw);
            } else {
                this.renderContent(request, response);
            }
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public abstract String getLabel();

    public abstract String getTitle();

    protected String[] getCssReferences() {
        return null;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public final Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext != null ? bundleContext.getBundle() : null;
    }

    protected Object getResourceProvider() {
        return this;
    }

    private final Method getGetResourceMethod() {
        if (this.getResourceMethodChecked) {
            return this.getResourceMethod;
        }
        Method tmpGetResourceMethod = null;
        Object resourceProvider = this.getResourceProvider();
        if (resourceProvider != null) {
            try {
                block2: for (Class<?> cl = resourceProvider.getClass(); tmpGetResourceMethod == null && cl != (class$java$lang$Object == null ? AbstractWebConsolePlugin.class$("java.lang.Object") : class$java$lang$Object); cl = cl.getSuperclass()) {
                    Method[] methods = cl.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        int mod;
                        Method m = methods[i];
                        if (!GET_RESOURCE_METHOD_NAME.equals(m.getName()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != (class$java$lang$String == null ? AbstractWebConsolePlugin.class$("java.lang.String") : class$java$lang$String) || m.getReturnType() != (class$java$net$URL == null ? AbstractWebConsolePlugin.class$("java.net.URL") : class$java$net$URL) || !Modifier.isProtected(mod = m.getModifiers()) && !Modifier.isPublic(mod) && (!Modifier.isPrivate(mod) || cl != resourceProvider.getClass())) continue;
                        m.setAccessible(true);
                        tmpGetResourceMethod = m;
                        continue block2;
                    }
                }
            }
            catch (Throwable t) {
                tmpGetResourceMethod = null;
            }
        }
        this.getResourceMethod = tmpGetResourceMethod;
        this.getResourceMethodChecked = true;
        return this.getResourceMethod;
    }

    public void log(int level, String message) {
        if (logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message);
                return;
            }
            System.err.println(message);
        }
    }

    public void log(int level, String message, Throwable t) {
        if (logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message, t);
                return;
            }
            System.err.println(message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean spoolResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block14: {
            block13: {
                block12: {
                    block11: {
                        getResourceMethod = this.getGetResourceMethod();
                        if (getResourceMethod == null) {
                            return false;
                        }
                        pi = request.getPathInfo();
                        ins = null;
                        url = (URL)getResourceMethod.invoke(this.getResourceProvider(), new Object[]{pi});
                        if (url != null) break block11;
                        var7_9 = false;
                        IOUtils.closeQuietly(ins);
                        return var7_9;
                    }
                    connection = url.openConnection();
                    ins = connection.getInputStream();
                    if (ins != null) break block12;
                    var8_11 = false;
                    IOUtils.closeQuietly((InputStream)ins);
                    return var8_11;
                }
                lastModified = connection.getLastModified();
                if (lastModified <= 0L) ** GOTO lbl33
                ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince < lastModified / 1000L * 1000L) break block13;
                response.setStatus(304);
                var12_15 = true;
                IOUtils.closeQuietly((InputStream)ins);
                return var12_15;
            }
            try {
                response.setDateHeader("Last-Modified", lastModified);
lbl33:
                // 2 sources

                response.setContentType(this.getServletContext().getMimeType(pi));
                response.setIntHeader("Content-Length", connection.getContentLength());
                out = response.getOutputStream();
                buf = new byte[2048];
                while ((rd = ins.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
                var13_18 = true;
            }
            catch (IllegalAccessException iae) {
                IOUtils.closeQuietly(ins);
                break block14;
            }
            catch (InvocationTargetException ite) {
                IOUtils.closeQuietly(ins);
                break block14;
                {
                    catch (Throwable var14_19) {
                        IOUtils.closeQuietly(ins);
                        throw var14_19;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)ins);
            return var13_18;
        }
        return false;
    }

    protected PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        VariableResolver resolver;
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        String title = this.getTitle();
        if (title.startsWith("%")) {
            title = "${" + title.substring(1) + "}";
        }
        if ((resolver = WebConsoleUtil.getVariableResolver((ServletRequest)request)) instanceof DefaultVariableResolver) {
            DefaultVariableResolver r = (DefaultVariableResolver)resolver;
            r.put("head.title", title);
            r.put("head.label", this.getLabel());
            r.put("head.cssLinks", this.getCssLinks(appRoot));
            r.put("brand.name", brandingPlugin.getBrandName());
            r.put("brand.product.url", brandingPlugin.getProductURL());
            r.put("brand.product.name", brandingPlugin.getProductName());
            r.put("brand.product.img", AbstractWebConsolePlugin.toUrl(brandingPlugin.getProductImage(), appRoot));
            r.put("brand.favicon", AbstractWebConsolePlugin.toUrl(brandingPlugin.getFavIcon(), appRoot));
            r.put("brand.css", AbstractWebConsolePlugin.toUrl(brandingPlugin.getMainStyleSheet(), appRoot));
        }
        pw.println(this.getHeader());
        return pw;
    }

    protected void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        Map langMap;
        boolean linkToCurrent = true;
        String current = request.getPathInfo();
        int slash = current.indexOf("/", 1);
        if (slash < 0) {
            slash = current.length();
            linkToCurrent = false;
        }
        current = current.substring(1, slash);
        boolean disabled = false;
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Map labelMap = (Map)request.getAttribute("felix.webconsole.labelMap");
        if (labelMap != null) {
            TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            Iterator ri = labelMap.entrySet().iterator();
            while (ri.hasNext()) {
                Map.Entry labelMapEntry = ri.next();
                if (labelMapEntry.getKey() == null) continue;
                if (disabled || current.equals(labelMapEntry.getKey())) {
                    if (linkToCurrent) {
                        map.put(labelMapEntry.getValue(), "<div class='ui-state-active'><a href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a></div>");
                        continue;
                    }
                    map.put(labelMapEntry.getValue(), "<div class='ui-state-active'><span>" + labelMapEntry.getValue() + "</span></div>");
                    continue;
                }
                map.put(labelMapEntry.getValue(), "<div class='ui-state-default'><a href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a></div>");
            }
            pw.println("<div id='technav' class='ui-widget ui-widget-header'>");
            Iterator li = map.values().iterator();
            while (li.hasNext()) {
                pw.print(' ');
                pw.println(li.next());
            }
            pw.println("</div>");
        }
        if (null != (langMap = (Map)request.getAttribute("felix.webconsole.langMap")) && !langMap.isEmpty()) {
            String locale;
            Locale reqLocale = request.getLocale();
            String string = locale = null != reqLocale ? reqLocale.getLanguage() : Locale.getDefault().getLanguage();
            if (!langMap.containsKey(locale)) {
                locale = Locale.getDefault().getLanguage();
            }
            if (!langMap.containsKey(locale)) {
                locale = "en";
            }
            pw.println("<div id='langSelect'>");
            pw.println(" <span>");
            AbstractWebConsolePlugin.printLocaleElement(pw, appRoot, locale, langMap.get(locale));
            pw.println(" </span>");
            pw.println(" <span class='flags ui-helper-hidden'>");
            Iterator li = langMap.keySet().iterator();
            while (li.hasNext()) {
                Object l = li.next();
                if (l.equals(locale)) continue;
                AbstractWebConsolePlugin.printLocaleElement(pw, appRoot, l, langMap.get(l));
            }
            pw.println(" </span>");
            pw.println("</div>");
        }
    }

    private static final void printLocaleElement(PrintWriter pw, String appRoot, Object langCode, Object langName) {
        pw.print("  <img src='");
        pw.print(appRoot);
        pw.print("/res/flags/");
        pw.print(langCode);
        pw.print(".gif' alt='");
        pw.print(langCode);
        pw.print("' title='");
        pw.print(langName);
        pw.println("'/>");
    }

    protected void endResponse(PrintWriter pw) {
        pw.println(this.getFooter());
    }

    public static final String getParameter(HttpServletRequest request, String name) {
        return WebConsoleUtil.getParameter(request, name);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        WebConsoleUtil.sendRedirect(request, response, redirectUrl);
    }

    public static BrandingPlugin getBrandingPlugin() {
        return brandingPlugin;
    }

    public static final void setBrandingPlugin(BrandingPlugin brandingPlugin) {
        AbstractWebConsolePlugin.brandingPlugin = brandingPlugin == null ? DefaultBrandingPlugin.getInstance() : brandingPlugin;
    }

    public static final void setLogLevel(int logLevel) {
        AbstractWebConsolePlugin.logLevel = logLevel;
    }

    private final String getHeader() {
        if (HEADER == null) {
            HEADER = this.readTemplateFile(class$org$apache$felix$webconsole$AbstractWebConsolePlugin == null ? (class$org$apache$felix$webconsole$AbstractWebConsolePlugin = AbstractWebConsolePlugin.class$("org.apache.felix.webconsole.AbstractWebConsolePlugin")) : class$org$apache$felix$webconsole$AbstractWebConsolePlugin, "/templates/main_header.html");
        }
        return HEADER;
    }

    private final String getFooter() {
        if (FOOTER == null) {
            FOOTER = this.readTemplateFile(class$org$apache$felix$webconsole$AbstractWebConsolePlugin == null ? (class$org$apache$felix$webconsole$AbstractWebConsolePlugin = AbstractWebConsolePlugin.class$("org.apache.felix.webconsole.AbstractWebConsolePlugin")) : class$org$apache$felix$webconsole$AbstractWebConsolePlugin, "/templates/main_footer.html");
        }
        return FOOTER;
    }

    protected final String readTemplateFile(String templateFile) {
        return this.readTemplateFile(((Object)((Object)this)).getClass(), templateFile);
    }

    private final String readTemplateFile(Class clazz, String templateFile) {
        InputStream templateStream = clazz.getResourceAsStream(templateFile);
        if (templateStream != null) {
            try {
                String str = IOUtils.toString((InputStream)templateStream, (String)"UTF-8");
                switch (str.charAt(0)) {
                    case '\uefbb': 
                    case '\ufeff': 
                    case '\ufffe': {
                        String string = str.substring(1);
                        return string;
                    }
                }
                String string = str;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("readTemplateFile: Error loading " + templateFile + ": " + e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)templateStream);
            }
        }
        this.log(1, "readTemplateFile: File '" + templateFile + "' not found through class " + clazz);
        return "";
    }

    private final String getCssLinks(String appRoot) {
        String[] cssRefs = this.getCssReferences();
        if (cssRefs == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cssRefs.length; ++i) {
            buf.append("<link href='");
            buf.append(AbstractWebConsolePlugin.toUrl(cssRefs[i], appRoot));
            buf.append("' rel='stylesheet' type='text/css' />");
        }
        return buf.toString();
    }

    private static final String toUrl(String url, String appRoot) {
        if (url.startsWith("/")) {
            return appRoot + url;
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        brandingPlugin = DefaultBrandingPlugin.getInstance();
    }
}

