/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Envelope;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdmin;

public final class WireAdminConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Wire Admin";
    private static final String WIRE_ADMIN_NAME = "org.osgi.service.wireadmin.WireAdmin";

    public final String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printConfiguration(PrintWriter pw) {
        BundleContext bc = this.getBundleContext();
        ServiceReference ref = bc.getServiceReference(WIRE_ADMIN_NAME);
        try {
            Object service;
            Object object = service = ref != null ? bc.getService(ref) : null;
            if (service == null) {
                pw.println("No Wire Admin service available");
            } else {
                WireAdmin wireAdmin = (WireAdmin)service;
                Wire[] wires = wireAdmin.getWires(null);
                if (null == wires || 0 == wires.length) {
                    pw.println("No wires available");
                } else {
                    int i;
                    int len = wires.length;
                    int valid = 0;
                    int connected = 0;
                    for (i = 0; i < len; ++i) {
                        Wire wire = wires[i];
                        if (wire.isValid()) {
                            ++valid;
                        }
                        if (!wire.isConnected()) continue;
                        ++connected;
                    }
                    pw.print("Status: ");
                    pw.print(len);
                    pw.print(" wires available, ");
                    pw.print(valid);
                    pw.print(" valid, ");
                    pw.print(connected);
                    pw.print(" connected.");
                    pw.println();
                    pw.println();
                    for (i = 0; i < len; ++i) {
                        pw.print("#");
                        pw.print(i);
                        WireAdminConfigurationPrinter.print(wires[i], pw);
                    }
                }
            }
        }
        catch (InvalidSyntaxException ie) {
        }
        finally {
            if (ref != null) {
                bc.ungetService(ref);
            }
        }
    }

    private static final void print(Wire wire, PrintWriter pw) {
        int i;
        int len;
        pw.print("  Valid: ");
        pw.println(wire.isValid());
        pw.print("  Connected: ");
        pw.println(wire.isConnected());
        Object val = wire.poll();
        if (null == val) {
            pw.println("  Value: null");
        } else if (val instanceof Envelope) {
            WireAdminConfigurationPrinter.print(0, (Envelope)val, pw);
        } else if (val instanceof Envelope[]) {
            Envelope[] values = (Envelope[])val;
            len = values.length;
            for (i = 0; i < len; ++i) {
                WireAdminConfigurationPrinter.print(i, values[i], pw);
            }
        } else {
            pw.print("  Value: ");
            pw.print(val);
            pw.print(" (");
            pw.print(val.getClass().getName());
            pw.println(")");
        }
        String[] scope = wire.getScope();
        if (scope == null) {
            pw.println("  Scope: none");
        } else {
            pw.println("  Scope: ");
            len = scope.length;
            for (i = 0; i < len; ++i) {
                pw.print("              ");
                pw.println(scope[i]);
            }
        }
        Class[] flavors = wire.getFlavors();
        if (flavors == null) {
            pw.println("  Flavors: none");
        } else {
            pw.print("  Flavors: ");
            int len2 = flavors.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                pw.print(flavors[i2].getName());
                if (i2 >= len2 - 1) continue;
                pw.print(", ");
            }
            pw.println();
        }
        Dictionary props = wire.getProperties();
        if (props == null) {
            pw.println("  Properties: none");
        } else {
            pw.println("  Properties: ");
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                pw.print("    ");
                pw.print(key.toString());
                pw.print('=');
                pw.println(props.get(key));
            }
        }
        pw.println();
    }

    private static final void print(int index, Envelope envelope, PrintWriter pw) {
        pw.print("            : Envelope #");
        pw.print(index);
        pw.print("[scope=");
        pw.print(envelope.getScope());
        pw.print(",identification=");
        pw.print(envelope.getIdentification());
        pw.print(",value=");
        pw.print(envelope.getValue());
        pw.println("]");
    }
}

